/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.Preconditions;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.credential.CredentialPropertiesProvider;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;
import io.prestosql.plugin.jdbc.credential.DefaultCredentialPropertiesProvider;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class DriverConnectionFactory
implements ConnectionFactory {
    private final Driver driver;
    private final String connectionUrl;
    private final Properties connectionProperties;
    private final CredentialPropertiesProvider credentialPropertiesProvider;

    public DriverConnectionFactory(Driver driver, BaseJdbcConfig config, CredentialProvider credentialProvider) {
        this(driver, config.getConnectionUrl(), new Properties(), credentialProvider);
    }

    public DriverConnectionFactory(Driver driver, String connectionUrl, Properties connectionProperties, CredentialProvider credentialProvider) {
        this(driver, connectionUrl, connectionProperties, new DefaultCredentialPropertiesProvider(credentialProvider));
    }

    public DriverConnectionFactory(Driver driver, String connectionUrl, Properties connectionProperties, CredentialPropertiesProvider credentialPropertiesProvider) {
        this.driver = Objects.requireNonNull(driver, "driver is null");
        this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)Objects.requireNonNull(connectionProperties, "connectionProperties is null"));
        this.credentialPropertiesProvider = Objects.requireNonNull(credentialPropertiesProvider, "credentialPropertiesProvider is null");
    }

    @Override
    public Connection openConnection(JdbcIdentity identity) throws SQLException {
        Properties properties = this.getCredentialProperties(identity);
        Connection connection = this.driver.connect(this.connectionUrl, properties);
        Preconditions.checkState((connection != null ? 1 : 0) != 0, (Object)"Driver returned null connection");
        return connection;
    }

    private Properties getCredentialProperties(JdbcIdentity identity) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.connectionProperties);
        properties.putAll(this.credentialPropertiesProvider.getCredentialProperties(identity));
        return properties;
    }
}

