/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface JdbcClient {
    default public boolean schemaExists(JdbcIdentity identity, String schema) {
        return this.getSchemaNames(identity).contains(schema);
    }

    public Set<String> getSchemaNames(JdbcIdentity var1);

    public List<SchemaTableName> getTableNames(JdbcIdentity var1, Optional<String> var2);

    public Optional<JdbcTableHandle> getTableHandle(JdbcIdentity var1, SchemaTableName var2);

    public List<JdbcColumnHandle> getColumns(ConnectorSession var1, JdbcTableHandle var2);

    public Optional<ColumnMapping> toPrestoType(ConnectorSession var1, Connection var2, JdbcTypeHandle var3);

    public WriteMapping toWriteMapping(ConnectorSession var1, Type var2);

    public ConnectorSplitSource getSplits(ConnectorSession var1, JdbcTableHandle var2);

    public Connection getConnection(JdbcIdentity var1, JdbcSplit var2) throws SQLException;

    default public void abortReadConnection(Connection connection) throws SQLException {
    }

    public PreparedStatement buildSql(ConnectorSession var1, Connection var2, JdbcSplit var3, JdbcTableHandle var4, List<JdbcColumnHandle> var5) throws SQLException;

    public boolean supportsLimit();

    public boolean isLimitGuaranteed();

    public void addColumn(ConnectorSession var1, JdbcTableHandle var2, ColumnMetadata var3);

    public void dropColumn(JdbcIdentity var1, JdbcTableHandle var2, JdbcColumnHandle var3);

    public void renameColumn(JdbcIdentity var1, JdbcTableHandle var2, JdbcColumnHandle var3, String var4);

    public void renameTable(JdbcIdentity var1, JdbcTableHandle var2, SchemaTableName var3);

    public void createTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void commitCreateTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public JdbcOutputTableHandle beginInsertTable(ConnectorSession var1, JdbcTableHandle var2, List<JdbcColumnHandle> var3);

    public void finishInsertTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public void dropTable(JdbcIdentity var1, JdbcTableHandle var2);

    public void rollbackCreateTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public String buildInsertSql(JdbcOutputTableHandle var1);

    public Connection getConnection(JdbcIdentity var1, JdbcOutputTableHandle var2) throws SQLException;

    public PreparedStatement getPreparedStatement(Connection var1, String var2) throws SQLException;

    public TableStatistics getTableStatistics(ConnectorSession var1, JdbcTableHandle var2, TupleDomain<ColumnHandle> var3);

    public void createSchema(JdbcIdentity var1, String var2);

    public void dropSchema(JdbcIdentity var1, String var2);

    default public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return Optional.empty();
    }
}

