/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.prestosql.plugin.jdbc.JdbcConnector;
import io.prestosql.plugin.jdbc.JdbcHandleResolver;
import io.prestosql.plugin.jdbc.JdbcModule;
import io.prestosql.plugin.jdbc.credential.CredentialProviderModule;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.VersionEmbedder;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;

public class JdbcConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final JdbcModuleProvider moduleProvider;

    public JdbcConnectorFactory(String name, Module module) {
        this(name, JdbcModuleProvider.of(module));
    }

    public JdbcConnectorFactory(String name, JdbcModuleProvider moduleProvider) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.moduleProvider = Objects.requireNonNull(moduleProvider, "moduleProvider is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new JdbcHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager()), binder -> binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager()), binder -> binder.bind(VersionEmbedder.class).toInstance((Object)context.getVersionEmbedder()), new JdbcModule(catalogName), new CredentialProviderModule(), this.moduleProvider.getModule(catalogName)});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
        return (Connector)injector.getInstance(JdbcConnector.class);
    }

    public static interface JdbcModuleProvider {
        public Module getModule(String var1);

        public static JdbcModuleProvider of(Module module) {
            Objects.requireNonNull(module, "module is null");
            return catalogName -> module;
        }
    }
}

