/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.reflect.Reflection;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.log.Logger;
import io.prestosql.plugin.base.jmx.MBeanServerModule;
import io.prestosql.plugin.base.util.LoggingInvocationHandler;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.ForBaseJdbc;
import io.prestosql.plugin.jdbc.ForwardingJdbcClient;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.StatsCollecting;
import io.prestosql.plugin.jdbc.jmx.StatisticsAwareConnectionFactory;
import io.prestosql.plugin.jdbc.jmx.StatisticsAwareJdbcClient;
import java.lang.reflect.InvocationHandler;
import java.util.Objects;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MBeanModule;

public class JdbcDiagnosticModule
implements Module {
    private final String catalogName;

    public JdbcDiagnosticModule(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public void configure(Binder binder) {
        binder.install((Module)new MBeanServerModule());
        binder.install((Module)new MBeanModule());
        ExportBinder.newExporter((Binder)binder).export(Key.get(JdbcClient.class, StatsCollecting.class)).as(generator -> generator.generatedNameOf(JdbcClient.class, this.catalogName));
        ExportBinder.newExporter((Binder)binder).export(Key.get(ConnectionFactory.class, StatsCollecting.class)).as(generator -> generator.generatedNameOf(ConnectionFactory.class, this.catalogName));
    }

    @Provides
    @Singleton
    @StatsCollecting
    public JdbcClient createJdbcClientWithStats(@ForBaseJdbc JdbcClient client) {
        StatisticsAwareJdbcClient statisticsAwareJdbcClient = new StatisticsAwareJdbcClient(client);
        Logger logger = Logger.get((String)String.format("io.prestosql.plugin.jdbc.%s.jdbcclient", this.catalogName));
        JdbcClient loggingInvocationsJdbcClient = (JdbcClient)Reflection.newProxy(JdbcClient.class, (InvocationHandler)new LoggingInvocationHandler((Object)statisticsAwareJdbcClient, (LoggingInvocationHandler.ParameterNamesProvider)new LoggingInvocationHandler.ReflectiveParameterNamesProvider(), arg_0 -> ((Logger)logger).debug(arg_0)));
        return ForwardingJdbcClient.of(() -> {
            if (logger.isDebugEnabled()) {
                return loggingInvocationsJdbcClient;
            }
            return statisticsAwareJdbcClient;
        });
    }

    @Provides
    @Singleton
    @StatsCollecting
    public static ConnectionFactory createConnectionFactoryWithStats(@ForBaseJdbc ConnectionFactory connectionFactory) {
        return new StatisticsAwareConnectionFactory(connectionFactory);
    }
}

