/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.airlift.units.Duration;
import io.prestosql.plugin.jdbc.CachingJdbcClient;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcMetadata;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import io.prestosql.plugin.jdbc.StatsCollecting;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class JdbcMetadataFactory {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;

    @Inject
    public JdbcMetadataFactory(@StatsCollecting JdbcClient jdbcClient, JdbcMetadataConfig config) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        Objects.requireNonNull(config, "config is null");
        this.allowDropTable = config.isAllowDropTable();
    }

    public JdbcMetadata create() {
        return new JdbcMetadata(new CachingJdbcClient(this.jdbcClient, new Duration(1.0, TimeUnit.DAYS), true), this.allowDropTable);
    }
}

