/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.CachingJdbcClient;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcConnector;
import io.prestosql.plugin.jdbc.JdbcDiagnosticModule;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import io.prestosql.plugin.jdbc.JdbcMetadataFactory;
import io.prestosql.plugin.jdbc.JdbcPageSinkProvider;
import io.prestosql.plugin.jdbc.JdbcRecordSetProvider;
import io.prestosql.plugin.jdbc.JdbcSplitManager;
import io.prestosql.plugin.jdbc.SessionPropertiesProvider;
import io.prestosql.plugin.jdbc.StatsCollecting;
import io.prestosql.plugin.jdbc.TypeHandlingJdbcConfig;
import io.prestosql.plugin.jdbc.TypeHandlingJdbcPropertiesProvider;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.procedure.Procedure;
import java.util.Objects;
import javax.inject.Provider;

public class JdbcModule
implements Module {
    private final String catalogName;

    public JdbcModule(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public void configure(Binder binder) {
        binder.install((Module)new JdbcDiagnosticModule(this.catalogName));
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorAccessControl.class);
        JdbcModule.procedureBinder(binder);
        binder.bind(JdbcMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(JdbcSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcConnector.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcMetadataConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BaseJdbcConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TypeHandlingJdbcConfig.class);
        JdbcModule.bindSessionPropertiesProvider(binder, TypeHandlingJdbcPropertiesProvider.class);
        binder.bind(JdbcClient.class).to(CachingJdbcClient.class).in(Scopes.SINGLETON);
        binder.bind(ConnectionFactory.class).to(Key.get(ConnectionFactory.class, StatsCollecting.class));
    }

    public static Multibinder<SessionPropertiesProvider> sessionPropertiesProviderBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class);
    }

    public static void bindSessionPropertiesProvider(Binder binder, Class<? extends SessionPropertiesProvider> type) {
        JdbcModule.sessionPropertiesProviderBinder(binder).addBinding().to(type).in(Scopes.SINGLETON);
    }

    public static Multibinder<Procedure> procedureBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, Procedure.class);
    }

    public static void bindProcedure(Binder binder, Class<? extends Provider<? extends Procedure>> type) {
        JdbcModule.procedureBinder(binder).addBinding().toProvider(type).in(Scopes.SINGLETON);
    }
}

