/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class JdbcOutputTableHandle
implements ConnectorOutputTableHandle,
ConnectorInsertTableHandle {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final Optional<List<JdbcTypeHandle>> jdbcColumnTypes;
    private final String temporaryTableName;

    @JsonCreator
    public JdbcOutputTableHandle(@JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="jdbcColumnTypes") Optional<List<JdbcTypeHandle>> jdbcColumnTypes, @JsonProperty(value="temporaryTableName") String temporaryTableName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.temporaryTableName = Objects.requireNonNull(temporaryTableName, "temporaryTableName is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Objects.requireNonNull(columnTypes, "columnTypes is null");
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes sizes don't match");
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.columnTypes = ImmutableList.copyOf(columnTypes);
        Objects.requireNonNull(jdbcColumnTypes, "jdbcColumnTypes is null");
        jdbcColumnTypes.ifPresent(jdbcTypeHandles -> Preconditions.checkArgument((jdbcTypeHandles.size() == columnNames.size() ? 1 : 0) != 0, (Object)"columnNames and jdbcColumnTypes sizes don't match"));
        this.jdbcColumnTypes = jdbcColumnTypes.map(ImmutableList::copyOf);
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public Optional<List<JdbcTypeHandle>> getJdbcColumnTypes() {
        return this.jdbcColumnTypes;
    }

    @JsonProperty
    public String getTemporaryTableName() {
        return this.temporaryTableName;
    }

    public String toString() {
        return String.format("jdbc:%s.%s.%s", this.catalogName, this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName, this.columnNames, this.columnTypes, this.jdbcColumnTypes, this.temporaryTableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcOutputTableHandle other = (JdbcOutputTableHandle)obj;
        return Objects.equals(this.catalogName, other.catalogName) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.columnNames, other.columnNames) && Objects.equals(this.columnTypes, other.columnTypes) && Objects.equals(this.jdbcColumnTypes, other.jdbcColumnTypes) && Objects.equals(this.temporaryTableName, other.temporaryTableName);
    }
}

