/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;

public final class JdbcTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final Optional<List<JdbcColumnHandle>> columns;
    private final TupleDomain<ColumnHandle> constraint;
    private final OptionalLong limit;

    public JdbcTableHandle(SchemaTableName schemaTableName, @Nullable String catalogName, @Nullable String schemaName, String tableName) {
        this(schemaTableName, catalogName, schemaName, tableName, Optional.empty(), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty());
    }

    @JsonCreator
    public JdbcTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columns") Optional<List<JdbcColumnHandle>> columns, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="limit") OptionalLong limit) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columns, "columns is null");
        this.columns = columns.map(ImmutableList::copyOf);
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<List<JdbcColumnHandle>> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcTableHandle o = (JdbcTableHandle)obj;
        return Objects.equals(this.schemaTableName, o.schemaTableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.schemaTableName).append(" ");
        Joiner.on((String)".").skipNulls().appendTo(builder, (Object)this.catalogName, (Object)this.schemaName, new Object[]{this.tableName});
        this.columns.ifPresent(value -> builder.append(" columns=").append(value));
        this.limit.ifPresent(value -> builder.append(" limit=").append(value));
        return builder.toString();
    }
}

