/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.MoreObjects;
import io.prestosql.plugin.jdbc.BlockWriteFunction;
import io.prestosql.plugin.jdbc.BooleanWriteFunction;
import io.prestosql.plugin.jdbc.DoubleWriteFunction;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.plugin.jdbc.WriteFunction;
import java.util.Objects;

public final class WriteMapping {
    private final String dataType;
    private final WriteFunction writeFunction;

    public static WriteMapping booleanMapping(String dataType, BooleanWriteFunction writeFunction) {
        return new WriteMapping(dataType, writeFunction);
    }

    public static WriteMapping longMapping(String dataType, LongWriteFunction writeFunction) {
        return new WriteMapping(dataType, writeFunction);
    }

    public static WriteMapping doubleMapping(String dataType, DoubleWriteFunction writeFunction) {
        return new WriteMapping(dataType, writeFunction);
    }

    public static WriteMapping sliceMapping(String dataType, SliceWriteFunction writeFunction) {
        return new WriteMapping(dataType, writeFunction);
    }

    public static WriteMapping blockMapping(String dataType, BlockWriteFunction writeFunction) {
        return new WriteMapping(dataType, writeFunction);
    }

    private WriteMapping(String dataType, WriteFunction writeFunction) {
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        this.writeFunction = Objects.requireNonNull(writeFunction, "writeFunction is null");
    }

    public String getDataType() {
        return this.dataType;
    }

    public WriteFunction getWriteFunction() {
        return this.writeFunction;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataType", (Object)this.dataType).toString();
    }
}

