/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.base.security.CatalogAccessControlRule;
import io.prestosql.plugin.base.security.FileBasedSystemAccessControlRules;
import io.prestosql.plugin.base.security.ForwardingSystemAccessControl;
import io.prestosql.plugin.base.security.ImpersonationRule;
import io.prestosql.plugin.base.security.PrincipalUserMatchRule;
import io.prestosql.plugin.base.security.QueryAccessRule;
import io.prestosql.plugin.base.util.JsonUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaRoutineName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemAccessControlFactory;
import io.prestosql.spi.security.SystemSecurityContext;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class FileBasedSystemAccessControl
implements SystemAccessControl {
    private static final Logger log = Logger.get(FileBasedSystemAccessControl.class);
    public static final String NAME = "file";
    private final List<CatalogAccessControlRule> catalogRules;
    private final Optional<List<QueryAccessRule>> queryAccessRules;
    private final Optional<List<ImpersonationRule>> impersonationRules;
    private final Optional<List<PrincipalUserMatchRule>> principalUserMatchRules;

    private FileBasedSystemAccessControl(List<CatalogAccessControlRule> catalogRules, Optional<List<QueryAccessRule>> queryAccessRules, Optional<List<ImpersonationRule>> impersonationRules, Optional<List<PrincipalUserMatchRule>> principalUserMatchRules) {
        this.catalogRules = catalogRules;
        this.queryAccessRules = queryAccessRules;
        this.impersonationRules = impersonationRules;
        this.principalUserMatchRules = principalUserMatchRules;
    }

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        if (!this.impersonationRules.isPresent()) {
            if (!this.principalUserMatchRules.isPresent()) {
                AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)userName);
            }
            return;
        }
        for (ImpersonationRule rule : this.impersonationRules.get()) {
            Optional<Boolean> allowed = rule.match(context.getIdentity().getUser(), userName);
            if (!allowed.isPresent()) continue;
            if (allowed.get().booleanValue()) {
                return;
            }
            AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)userName);
        }
        AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)userName);
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(userName, "userName is null");
        if (!this.principalUserMatchRules.isPresent()) {
            return;
        }
        if (!principal.isPresent()) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        String principalName = principal.get().getName();
        for (PrincipalUserMatchRule rule : this.principalUserMatchRules.get()) {
            Optional<Boolean> allowed = rule.match(principalName, userName);
            if (!allowed.isPresent()) continue;
            if (allowed.get().booleanValue()) {
                return;
            }
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        AccessDeniedException.denySetUser(principal, (String)userName);
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
        if (!this.queryAccessRules.isPresent()) {
            return;
        }
        if (!this.canAccessQuery(context.getIdentity(), QueryAccessRule.AccessMode.EXECUTE)) {
            AccessDeniedException.denyViewQuery();
        }
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        if (!this.queryAccessRules.isPresent()) {
            return;
        }
        if (!this.canAccessQuery(context.getIdentity(), QueryAccessRule.AccessMode.VIEW)) {
            AccessDeniedException.denyViewQuery();
        }
    }

    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        if (!this.queryAccessRules.isPresent()) {
            return queryOwners;
        }
        Identity identity = context.getIdentity();
        return (Set)queryOwners.stream().filter(owner -> this.canAccessQuery(identity, QueryAccessRule.AccessMode.VIEW)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        if (!this.queryAccessRules.isPresent()) {
            return;
        }
        if (!this.canAccessQuery(context.getIdentity(), QueryAccessRule.AccessMode.KILL)) {
            AccessDeniedException.denyViewQuery();
        }
    }

    private boolean canAccessQuery(Identity identity, QueryAccessRule.AccessMode requiredAccess) {
        if (this.queryAccessRules.isPresent()) {
            for (QueryAccessRule rule : this.queryAccessRules.get()) {
                Optional<Set<QueryAccessRule.AccessMode>> accessMode = rule.match(identity.getUser());
                if (!accessMode.isPresent()) continue;
                return accessMode.get().contains((Object)requiredAccess);
            }
        }
        return false;
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        if (!this.canAccessCatalog(context.getIdentity(), catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            AccessDeniedException.denyCatalogAccess((String)catalogName);
        }
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        ImmutableSet.Builder filteredCatalogs = ImmutableSet.builder();
        for (String catalog : catalogs) {
            if (!this.canAccessCatalog(context.getIdentity(), catalog, CatalogAccessControlRule.AccessMode.READ_ONLY)) continue;
            filteredCatalogs.add((Object)catalog);
        }
        return filteredCatalogs.build();
    }

    private boolean canAccessCatalog(Identity identity, String catalogName, CatalogAccessControlRule.AccessMode requiredAccess) {
        for (CatalogAccessControlRule rule : this.catalogRules) {
            Optional<CatalogAccessControlRule.AccessMode> accessMode = rule.match(identity.getUser(), identity.getGroups(), catalogName);
            if (!accessMode.isPresent()) continue;
            return accessMode.get().implies(requiredAccess);
        }
        return false;
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.canAccessCatalog(context.getIdentity(), schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyCreateSchema((String)schema.toString());
        }
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.canAccessCatalog(context.getIdentity(), schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDropSchema((String)schema.toString());
        }
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        if (!this.canAccessCatalog(context.getIdentity(), schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRenameSchema((String)schema.toString(), (String)newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, PrestoPrincipal principal) {
        if (!this.canAccessCatalog(context.getIdentity(), schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denySetSchemaAuthorization((String)schema.toString(), (PrestoPrincipal)principal);
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        if (!this.canAccessCatalog(context.getIdentity(), catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            return ImmutableSet.of();
        }
        return schemaNames;
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyShowCreateTable((String)table.toString());
        }
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyCreateTable((String)table.toString());
        }
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDropTable((String)table.toString());
        }
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRenameTable((String)table.toString(), (String)newTable.toString());
        }
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyCommentTable((String)table.toString());
        }
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        if (!this.canAccessCatalog(context.getIdentity(), catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            return ImmutableSet.of();
        }
        return tableNames;
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public List<ColumnMetadata> filterColumns(SystemSecurityContext context, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
        if (!this.canAccessCatalog(context.getIdentity(), tableName.getCatalogName(), CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            return ImmutableList.of();
        }
        return columns;
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyAddColumn((String)table.toString());
        }
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDropColumn((String)table.toString());
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRenameColumn((String)table.toString());
        }
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyInsertTable((String)table.toString());
        }
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDeleteTable((String)table.toString());
        }
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.canAccessCatalog(context.getIdentity(), view.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyCreateView((String)view.toString());
        }
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        if (!this.canAccessCatalog(context.getIdentity(), view.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRenameView((String)view.toString(), (String)newView.toString());
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.canAccessCatalog(context.getIdentity(), view.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDropView((String)view.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyCreateViewWithSelect((String)table.toString(), (Identity)context.getIdentity());
        }
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, PrestoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean grantOption) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.toString(), (String)table.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOption) {
        if (!this.canAccessCatalog(context.getIdentity(), table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.toString(), (String)table.toString());
        }
    }

    public void checkCanShowRoles(SystemSecurityContext context, String catalogName) {
    }

    public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
    }

    public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
    }

    public Optional<ViewExpression> getRowFilter(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        return Optional.empty();
    }

    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        return Optional.empty();
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return FileBasedSystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Objects.requireNonNull(config, "config is null");
            String configFileName = config.get("security.config-file");
            Preconditions.checkState((configFileName != null ? 1 : 0) != 0, (String)"Security configuration must contain the '%s' property", (Object)"security.config-file");
            if (config.containsKey("security.refresh-period")) {
                Duration refreshPeriod;
                try {
                    refreshPeriod = Duration.valueOf((String)config.get("security.refresh-period"));
                }
                catch (IllegalArgumentException e) {
                    throw this.invalidRefreshPeriodException(config, configFileName);
                }
                if (refreshPeriod.toMillis() == 0L) {
                    throw this.invalidRefreshPeriodException(config, configFileName);
                }
                return ForwardingSystemAccessControl.of((Supplier<SystemAccessControl>)Suppliers.memoizeWithExpiration(() -> {
                    log.info("Refreshing system access control from %s", new Object[]{configFileName});
                    return this.create(configFileName);
                }, (long)refreshPeriod.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            return this.create(configFileName);
        }

        private PrestoException invalidRefreshPeriodException(Map<String, String> config, String configFileName) {
            return new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, String.format("Invalid duration value '%s' for property '%s' in '%s'", config.get("security.refresh-period"), "security.refresh-period", configFileName));
        }

        private SystemAccessControl create(String configFileName) {
            FileBasedSystemAccessControlRules rules = JsonUtils.parseJson(Paths.get(configFileName, new String[0]), FileBasedSystemAccessControlRules.class);
            ImmutableList.Builder catalogRulesBuilder = ImmutableList.builder();
            catalogRulesBuilder.addAll(rules.getCatalogRules());
            catalogRulesBuilder.add((Object)new CatalogAccessControlRule(CatalogAccessControlRule.AccessMode.ALL, Optional.of(Pattern.compile(".*")), Optional.empty(), Optional.of(Pattern.compile("system"))));
            return new FileBasedSystemAccessControl((List)catalogRulesBuilder.build(), rules.getQueryAccessRules(), rules.getImpersonationRules(), rules.getPrincipalUserMatchRules());
        }
    }
}

