/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import io.airlift.units.DataSize;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.plugin.resourcegroups.FileResourceGroupConfig;
import io.prestosql.plugin.resourcegroups.FileResourceGroupConfigurationManager;
import io.prestosql.plugin.resourcegroups.ManagerSpec;
import io.prestosql.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.prestosql.plugin.resourcegroups.SelectorSpec;
import io.prestosql.plugin.resourcegroups.TestingResourceGroup;
import io.prestosql.plugin.resourcegroups.TestingResourceGroups;
import io.prestosql.spi.memory.MemoryPoolInfo;
import io.prestosql.spi.resourcegroups.ResourceGroup;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.resourcegroups.SchedulingPolicy;
import io.prestosql.spi.resourcegroups.SelectionContext;
import io.prestosql.spi.resourcegroups.SelectionCriteria;
import io.prestosql.spi.session.ResourceEstimates;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFileResourceGroupConfigurationManager {
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());

    @Test
    public void testInvalid() {
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_root.json", "Duplicated root group: global");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_sub_group.json", "Duplicated sub group: sub");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_group_id.json", "Invalid resource group name. 'glo.bal' contains a '.'");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_weighted_scheduling_policy.json", "Must specify scheduling weight for all sub-groups of 'requests' or none of them");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_unused_field.json", "Unknown property at line 8:6: maxFoo");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_query_priority_scheduling_policy.json", "Must use 'weighted' or 'weighted_fair' scheduling policy if specifying scheduling weight for 'requests'");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_extract_variable.json", "Invalid resource group name.*");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_query_type.json", "Selector specifies an invalid query type: invalid_query_type");
        TestFileResourceGroupConfigurationManager.assertFails("resource_groups_config_bad_selector.json", "Selector refers to nonexistent group: a.b.c.X");
    }

    @Test
    public void testQueryTypeConfiguration() {
        FileResourceGroupConfigurationManager manager = TestFileResourceGroupConfigurationManager.parse("resource_groups_config_query_type.json");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("select"), "global.select");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("explain"), "global.explain");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("insert"), "global.insert");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("delete"), "global.delete");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("describe"), "global.describe");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("data_definition"), "global.data_definition");
        TestFileResourceGroupConfigurationManager.assertMatch(manager, TestFileResourceGroupConfigurationManager.queryTypeSelectionCriteria("sth_else"), "global.other");
    }

    @Test
    public void testMatchByUserGroups() {
        ManagerSpec managerSpec = TestingResourceGroups.managerSpec(TestingResourceGroups.resourceGroupSpec("group"), (List<TestingResourceGroups.SelectorSpecBuilder>)ImmutableList.of((Object)TestingResourceGroups.selectorSpec(TestingResourceGroups.groupIdTemplate("group")).userGroups("first matching", "second matching")));
        FileResourceGroupConfigurationManager groupManager = new FileResourceGroupConfigurationManager((poolId, listener) -> {}, managerSpec);
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userGroupsSelectionCriteria("not matching"))).isEmpty();
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userGroupsSelectionCriteria("first matching"))).map(SelectionContext::getContext).isEqualTo(Optional.of(TestingResourceGroups.groupIdTemplate("group")));
    }

    @Test
    public void testMatchByUsers() {
        ManagerSpec managerSpec = TestingResourceGroups.managerSpec(TestingResourceGroups.resourceGroupSpec("group"), (List<TestingResourceGroups.SelectorSpecBuilder>)ImmutableList.of((Object)TestingResourceGroups.selectorSpec(TestingResourceGroups.groupIdTemplate("group")).users("First matching user", "Second matching user")));
        FileResourceGroupConfigurationManager groupManager = new FileResourceGroupConfigurationManager((poolId, listener) -> {}, managerSpec);
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userSelectionCriteria("Not matching user"))).isEmpty();
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userSelectionCriteria("First matching user"))).map(SelectionContext::getContext).isEqualTo(Optional.of(TestingResourceGroups.groupIdTemplate("group")));
    }

    @Test
    public void testMatchByUsersAndGroups() {
        ManagerSpec managerSpec = TestingResourceGroups.managerSpec(TestingResourceGroups.resourceGroupSpec("group"), (List<TestingResourceGroups.SelectorSpecBuilder>)ImmutableList.of((Object)TestingResourceGroups.selectorSpec(TestingResourceGroups.groupIdTemplate("group")).userGroups("Matching group").users("Matching user")));
        FileResourceGroupConfigurationManager groupManager = new FileResourceGroupConfigurationManager((poolId, listener) -> {}, managerSpec);
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Matching user", "Not matching group", new String[0]))).isEmpty();
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Not matching user", "Matching group", new String[0]))).isEmpty();
        Assertions.assertThat((Optional)groupManager.match(TestFileResourceGroupConfigurationManager.userAndUserGroupsSelectionCriteria("Matching user", "Matching group", new String[0]))).map(SelectionContext::getContext).isEqualTo(Optional.of(TestingResourceGroups.groupIdTemplate("group")));
    }

    @Test
    public void testUserGroupsConfiguration() {
        ManagerSpec spec = TestFileResourceGroupConfigurationManager.parseManagerSpec("resource_groups_config_user_groups.json");
        Assertions.assertThat(spec.getSelectors().stream().map(SelectorSpec::getUserGroupRegex).map(pattern -> pattern.map(Pattern::pattern))).containsOnly((Object[])new Optional[]{Optional.of("groupA")});
    }

    @Test
    public void testConfiguration() {
        FileResourceGroupConfigurationManager manager = TestFileResourceGroupConfigurationManager.parse("resource_groups_config.json");
        ResourceGroupId globalId = new ResourceGroupId("global");
        TestingResourceGroup global = new TestingResourceGroup(globalId);
        manager.configure((ResourceGroup)global, new SelectionContext(globalId, (Object)new ResourceGroupIdTemplate("global")));
        Assert.assertEquals((long)global.getSoftMemoryLimitBytes(), (long)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assert.assertEquals((Object)global.getSoftCpuLimit(), (Object)Duration.ofHours(1L));
        Assert.assertEquals((Object)global.getHardCpuLimit(), (Object)Duration.ofDays(1L));
        Assert.assertEquals((long)global.getCpuQuotaGenerationMillisPerSecond(), (long)24000L);
        Assert.assertEquals((int)global.getMaxQueuedQueries(), (int)1000);
        Assert.assertEquals((int)global.getHardConcurrencyLimit(), (int)100);
        Assert.assertEquals((Object)global.getSchedulingPolicy(), (Object)SchedulingPolicy.WEIGHTED);
        Assert.assertEquals((int)global.getSchedulingWeight(), (int)0);
        Assert.assertTrue((boolean)global.getJmxExport());
        ResourceGroupId subId = new ResourceGroupId(globalId, "sub");
        TestingResourceGroup sub = new TestingResourceGroup(subId);
        manager.configure((ResourceGroup)sub, new SelectionContext(subId, (Object)new ResourceGroupIdTemplate("global.sub")));
        Assert.assertEquals((long)sub.getSoftMemoryLimitBytes(), (long)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assert.assertEquals((int)sub.getHardConcurrencyLimit(), (int)3);
        Assert.assertEquals((int)sub.getMaxQueuedQueries(), (int)4);
        Assert.assertNull((Object)sub.getSchedulingPolicy());
        Assert.assertEquals((int)sub.getSchedulingWeight(), (int)5);
        Assert.assertFalse((boolean)sub.getJmxExport());
    }

    @Test
    public void testExtractVariableConfiguration() {
        FileResourceGroupConfigurationManager manager = TestFileResourceGroupConfigurationManager.parse("resource_groups_config_extract_variable.json");
        SelectionContext<ResourceGroupIdTemplate> selectionContext = TestFileResourceGroupConfigurationManager.match(manager, TestFileResourceGroupConfigurationManager.userAndSourceSelectionCriteria("someuser@presto.io", "scheduler.us_east.12"));
        Assert.assertEquals((String)selectionContext.getResourceGroupId().toString(), (String)"global.presto:us_east:12");
        TestingResourceGroup resourceGroup = new TestingResourceGroup(selectionContext.getResourceGroupId());
        manager.configure((ResourceGroup)resourceGroup, selectionContext);
        Assert.assertEquals((int)resourceGroup.getHardConcurrencyLimit(), (int)3);
        selectionContext = TestFileResourceGroupConfigurationManager.match(manager, TestFileResourceGroupConfigurationManager.userAndSourceSelectionCriteria("nobody", "rg-abcdefghijkl"));
        Assert.assertEquals((String)selectionContext.getResourceGroupId().toString(), (String)"global.abcdefghijkl");
        resourceGroup = new TestingResourceGroup(selectionContext.getResourceGroupId());
        manager.configure((ResourceGroup)resourceGroup, selectionContext);
        Assert.assertEquals((int)resourceGroup.getHardConcurrencyLimit(), (int)115);
    }

    @Test
    public void testDocsExample() {
        long generalPoolSize = 31415926535900L;
        FileResourceGroupConfigurationManager manager = new FileResourceGroupConfigurationManager((poolId, listener) -> {
            if (poolId.equals((Object)LocalMemoryManager.GENERAL_POOL)) {
                listener.accept(new MemoryPoolInfo(generalPoolSize, 0L, 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
            }
        }, new FileResourceGroupConfig().setConfigFile("../presto-docs/src/main/sphinx/admin/resource-groups-example.json"));
        SelectionContext<ResourceGroupIdTemplate> selectionContext = TestFileResourceGroupConfigurationManager.match(manager, new SelectionCriteria(true, "Alice", (Set)ImmutableSet.of(), Optional.of("jdbc#powerfulbi"), (Set)ImmutableSet.of((Object)"hipri"), EMPTY_RESOURCE_ESTIMATES, Optional.of("select")));
        Assert.assertEquals((String)selectionContext.getResourceGroupId().toString(), (String)"global.adhoc.bi-powerfulbi.Alice");
        TestingResourceGroup resourceGroup = new TestingResourceGroup(selectionContext.getResourceGroupId());
        manager.configure((ResourceGroup)resourceGroup, selectionContext);
        Assert.assertEquals((int)resourceGroup.getHardConcurrencyLimit(), (int)3);
        Assert.assertEquals((int)resourceGroup.getMaxQueuedQueries(), (int)10);
        Assert.assertEquals((long)resourceGroup.getSoftMemoryLimitBytes(), (long)(generalPoolSize / 10L));
    }

    @Test
    public void testLegacyConfiguration() {
        FileResourceGroupConfigurationManager manager = TestFileResourceGroupConfigurationManager.parse("resource_groups_config_legacy.json");
        ResourceGroupId globalId = new ResourceGroupId("global");
        TestingResourceGroup global = new TestingResourceGroup(globalId);
        manager.configure((ResourceGroup)global, new SelectionContext(globalId, (Object)new ResourceGroupIdTemplate("global")));
        Assert.assertEquals((long)global.getSoftMemoryLimitBytes(), (long)DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assert.assertEquals((int)global.getMaxQueuedQueries(), (int)99);
        Assert.assertEquals((int)global.getHardConcurrencyLimit(), (int)42);
    }

    private static void assertMatch(FileResourceGroupConfigurationManager manager, SelectionCriteria criteria, String expectedResourceGroup) {
        ResourceGroupId resourceGroupId = TestFileResourceGroupConfigurationManager.match(manager, criteria).getResourceGroupId();
        Assert.assertEquals((String)resourceGroupId.toString(), (String)expectedResourceGroup, (String)String.format("Expected: '%s' resource group, found: %s", expectedResourceGroup, resourceGroupId));
    }

    private static SelectionContext<ResourceGroupIdTemplate> match(FileResourceGroupConfigurationManager manager, SelectionCriteria criteria) {
        return (SelectionContext)manager.match(criteria).orElseThrow(() -> new IllegalStateException("No match"));
    }

    private static void assertFails(String fileName, String expectedPattern) {
        Assertions.assertThatThrownBy(() -> TestFileResourceGroupConfigurationManager.parse(fileName)).hasMessageMatching(expectedPattern);
    }

    private static FileResourceGroupConfigurationManager parse(String fileName) {
        FileResourceGroupConfig config = new FileResourceGroupConfig();
        config.setConfigFile(Resources.getResource((String)fileName).getPath());
        return new FileResourceGroupConfigurationManager((poolId, listener) -> {}, config);
    }

    private static ManagerSpec parseManagerSpec(String fileName) {
        FileResourceGroupConfig config = new FileResourceGroupConfig();
        config.setConfigFile(Resources.getResource((String)fileName).getPath());
        return FileResourceGroupConfigurationManager.parseManagerSpec((FileResourceGroupConfig)config);
    }

    private static SelectionCriteria userAndSourceSelectionCriteria(String user, String source) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.of(), Optional.of(source), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }

    private static SelectionCriteria userSelectionCriteria(String user) {
        return TestFileResourceGroupConfigurationManager.userAndSourceSelectionCriteria(user, "source");
    }

    private static SelectionCriteria queryTypeSelectionCriteria(String queryType) {
        return new SelectionCriteria(true, "test_user", (Set)ImmutableSet.of(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.of(queryType));
    }

    private static SelectionCriteria userGroupsSelectionCriteria(String ... groups) {
        return new SelectionCriteria(true, "test_user", (Set)ImmutableSet.copyOf((Object[])groups), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }

    private static SelectionCriteria userAndUserGroupsSelectionCriteria(String user, String group, String ... groups) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.builder().add((Object)group).add((Object[])groups).build(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
    }
}

