/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.prestosql.plugin.resourcegroups.StaticSelector;
import io.prestosql.plugin.resourcegroups.VariableMap;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.resourcegroups.SelectionContext;
import io.prestosql.spi.resourcegroups.SelectionCriteria;
import io.prestosql.spi.session.ResourceEstimates;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestResourceGroupIdTemplate {
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());

    @Test
    public void testExpansion() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.${USER}.${SOURCE}");
        ResourceGroupId expected = new ResourceGroupId(new ResourceGroupId(new ResourceGroupId("test"), "u"), "s");
        Assert.assertEquals((Object)template.expandTemplate(new VariableMap((Map)ImmutableMap.of((Object)"USER", (Object)"u", (Object)"SOURCE", (Object)"s"))), (Object)expected);
        template = new ResourceGroupIdTemplate("test.${USER}");
        Assert.assertEquals((Object)template.expandTemplate(new VariableMap((Map)ImmutableMap.of((Object)"USER", (Object)"alice.smith", (Object)"SOURCE", (Object)"s"))), (Object)new ResourceGroupId(new ResourceGroupId("test"), "alice.smith"));
    }

    @Test
    public void testExtraction() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.job_${pipeline}_user:${USER}.${USER}");
        ResourceGroupId expected = new ResourceGroupId(new ResourceGroupId(new ResourceGroupId(new ResourceGroupId("test"), "pipeline"), "job_testpipeline_user:user"), "user");
        Pattern sourcePattern = Pattern.compile("scheduler.important.(?<pipeline>[^\\[]*).*");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(sourcePattern), Optional.empty(), Optional.empty(), Optional.empty(), template);
        SelectionCriteria context = new SelectionCriteria(true, "user", (Set)ImmutableSet.of(), Optional.of("scheduler.important.testpipeline[5]"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
        Assert.assertEquals(selector.match(context).map(SelectionContext::getResourceGroupId), Optional.of(expected));
    }

    @Test
    public void testNoSource() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.${pipeline}.${SOURCE}_s");
        ResourceGroupId expected = new ResourceGroupId(new ResourceGroupId(new ResourceGroupId(new ResourceGroupId("test"), "pipeline"), "testpipeline"), "_s");
        Pattern userPattern = Pattern.compile("scheduler.important.(?<pipeline>[^\\[]*).*");
        StaticSelector selector = new StaticSelector(Optional.of(userPattern), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), template);
        SelectionCriteria context = new SelectionCriteria(true, "scheduler.important.testpipeline[5]", (Set)ImmutableSet.of(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
        Assert.assertEquals(selector.match(context).map(SelectionContext::getResourceGroupId), Optional.of(expected));
    }

    @Test
    public void testNoMatch() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.${pipeline}.${USER}");
        Pattern sourcePattern = Pattern.compile("scheduler.important.(?<pipeline>[^\\[]*).*");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(sourcePattern), Optional.empty(), Optional.empty(), Optional.empty(), template);
        SelectionCriteria context = new SelectionCriteria(true, "user", (Set)ImmutableSet.of(), Optional.of("scheduler.testpipeline[5]"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
        Assert.assertFalse((boolean)selector.match(context).isPresent());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="unresolved variables \\[user\\] in resource group ID.*")
    public void testUnresolvedVariableLoadTime() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.${pipeline}.${user}");
        Pattern sourcePattern = Pattern.compile("scheduler.important.(?<pipeline>[^\\[]*).*");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(sourcePattern), Optional.empty(), Optional.empty(), Optional.empty(), template);
        SelectionCriteria context = new SelectionCriteria(true, "user", (Set)ImmutableSet.of(), Optional.of("scheduler.important.testpipeline[5]"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
        selector.match(context);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="unresolved variable 'pipeline' in resource group '\\$\\{pipeline\\}', available.*")
    public void testUnresolvedVariableRunTime() {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate("test.pipeline.${pipeline}.${USER}");
        Pattern sourcePattern = Pattern.compile("scheduler.important.(testpipeline\\[|(?<pipeline>[^\\[]*)).*");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(sourcePattern), Optional.empty(), Optional.empty(), Optional.empty(), template);
        SelectionCriteria context = new SelectionCriteria(true, "user", (Set)ImmutableSet.of(), Optional.of("scheduler.important.testpipeline[5]"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty());
        selector.match(context);
    }
}

