/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.prestosql.plugin.resourcegroups.SelectorResourceEstimate;
import io.prestosql.plugin.resourcegroups.StaticSelector;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.resourcegroups.SelectionContext;
import io.prestosql.spi.resourcegroups.SelectionCriteria;
import io.prestosql.spi.session.ResourceEstimates;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStaticSelector {
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());

    @Test
    public void testUserRegex() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.of(Pattern.compile("user.*")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assert.assertEquals(selector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
        Assert.assertEquals(selector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
        Assert.assertEquals((Object)selector.match(this.newSelectionCriteria("A.user", null, (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES)), Optional.empty());
    }

    @Test
    public void testSourceRegex() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.of(Pattern.compile(".*source.*")), Optional.empty(), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assert.assertEquals((Object)selector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES)), Optional.empty());
        Assert.assertEquals(selector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
        Assert.assertEquals(selector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
    }

    @Test
    public void testClientTags() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector selector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(ImmutableList.of((Object)"tag1", (Object)"tag2")), Optional.empty(), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assert.assertEquals(selector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2"), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
        Assert.assertEquals((Object)selector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES)), Optional.empty());
        Assert.assertEquals((Object)selector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1"), EMPTY_RESOURCE_ESTIMATES)), Optional.empty());
        Assert.assertEquals(selector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2", (Object)"tag3"), EMPTY_RESOURCE_ESTIMATES)).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
    }

    @Test
    public void testSelectorResourceEstimate() {
        ResourceGroupId resourceGroupId = new ResourceGroupId(new ResourceGroupId("global"), "foo");
        StaticSelector smallQuerySelector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new SelectorResourceEstimate(Optional.of(new SelectorResourceEstimate.Range(Optional.empty(), Optional.of(Duration.valueOf((String)"5m")))), Optional.empty(), Optional.of(new SelectorResourceEstimate.Range(Optional.empty(), Optional.of(DataSize.valueOf((String)"500MB")))))), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assert.assertEquals(smallQuerySelector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2"), new ResourceEstimates(Optional.of(java.time.Duration.ofMinutes(4L)), Optional.empty(), Optional.of(DataSize.of((long)400L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes())))).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
        Assert.assertEquals(smallQuerySelector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1"), new ResourceEstimates(Optional.of(java.time.Duration.ofMinutes(4L)), Optional.empty(), Optional.of(DataSize.of((long)600L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes())))).map(SelectionContext::getResourceGroupId), Optional.empty());
        Assert.assertEquals(smallQuerySelector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), new ResourceEstimates(Optional.of(java.time.Duration.ofMinutes(4L)), Optional.empty(), Optional.empty()))).map(SelectionContext::getResourceGroupId), Optional.empty());
        StaticSelector largeQuerySelector = new StaticSelector(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new SelectorResourceEstimate(Optional.empty(), Optional.empty(), Optional.of(new SelectorResourceEstimate.Range(Optional.of(DataSize.valueOf((String)"5TB")), Optional.empty())))), Optional.empty(), new ResourceGroupIdTemplate("global.foo"));
        Assert.assertEquals(largeQuerySelector.match(this.newSelectionCriteria("userA", null, (Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2"), new ResourceEstimates(Optional.of(java.time.Duration.ofHours(100L)), Optional.empty(), Optional.of(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.TERABYTE).toBytes())))).map(SelectionContext::getResourceGroupId), Optional.empty());
        Assert.assertEquals(largeQuerySelector.match(this.newSelectionCriteria("A.user", "a source b", (Set<String>)ImmutableSet.of((Object)"tag1"), new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.of(DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.TERABYTE).toBytes())))).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
        Assert.assertEquals(largeQuerySelector.match(this.newSelectionCriteria("userB", "source", (Set<String>)ImmutableSet.of(), new ResourceEstimates(Optional.of(java.time.Duration.ofSeconds(1L)), Optional.of(java.time.Duration.ofSeconds(1L)), Optional.of(DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.TERABYTE).toBytes())))).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId));
    }

    private SelectionCriteria newSelectionCriteria(String user, String source, Set<String> tags, ResourceEstimates resourceEstimates) {
        return new SelectionCriteria(true, user, (Set)ImmutableSet.of(), Optional.ofNullable(source), tags, resourceEstimates, Optional.empty());
    }
}

