/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.plugin.resourcegroups.ManagerSpec;
import io.prestosql.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.prestosql.plugin.resourcegroups.ResourceGroupNameTemplate;
import io.prestosql.plugin.resourcegroups.ResourceGroupSpec;
import io.prestosql.plugin.resourcegroups.SelectorSpec;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TestingResourceGroups {
    private TestingResourceGroups() {
    }

    public static ManagerSpec managerSpec(List<ResourceGroupSpec> resourceGroupSpecs, List<SelectorSpecBuilder> selectors) {
        return new ManagerSpec(resourceGroupSpecs, (List)selectors.stream().map(SelectorSpecBuilder::build).collect(ImmutableList.toImmutableList()), Optional.empty());
    }

    public static ManagerSpec managerSpec(ResourceGroupSpec resourceGroupSpec, List<SelectorSpecBuilder> selectors) {
        return TestingResourceGroups.managerSpec((List<ResourceGroupSpec>)ImmutableList.of((Object)resourceGroupSpec), selectors);
    }

    public static ResourceGroupSpec resourceGroupSpec(String segmentName) {
        return new ResourceGroupSpec(new ResourceGroupNameTemplate(segmentName), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toString(), 10, Optional.empty(), Optional.of(10), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static ResourceGroupIdTemplate groupIdTemplate(String groupIdTemplate) {
        return new ResourceGroupIdTemplate(groupIdTemplate);
    }

    public static SelectorSpecBuilder selectorSpec(ResourceGroupIdTemplate groupIdTemplate) {
        return new SelectorSpecBuilder(new SelectorSpec(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), groupIdTemplate));
    }

    private static Pattern matchLiterals(String[] literals) {
        Preconditions.checkArgument((literals.length > 0 ? 1 : 0) != 0, (Object)"literals is empty");
        return Pattern.compile(Stream.of(literals).map(Pattern::quote).collect(Collectors.joining("|")));
    }

    public static class SelectorSpecBuilder {
        private final SelectorSpec spec;

        private SelectorSpecBuilder(SelectorSpec spec) {
            Objects.requireNonNull(spec, "spec is null");
            this.spec = spec;
        }

        public SelectorSpec build() {
            return this.spec;
        }

        public SelectorSpecBuilder users(String ... users) {
            return new SelectorSpecBuilder(new SelectorSpec(Optional.of(TestingResourceGroups.matchLiterals(users)), this.spec.getUserGroupRegex(), this.spec.getSourceRegex(), this.spec.getQueryType(), this.spec.getClientTags(), this.spec.getResourceEstimate(), this.spec.getGroup()));
        }

        public SelectorSpecBuilder userGroups(String ... groups) {
            return new SelectorSpecBuilder(new SelectorSpec(this.spec.getUserRegex(), Optional.of(TestingResourceGroups.matchLiterals(groups)), this.spec.getSourceRegex(), this.spec.getQueryType(), this.spec.getClientTags(), this.spec.getResourceEstimate(), this.spec.getGroup()));
        }
    }
}

