/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups.db;

import io.prestosql.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.prestosql.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.prestosql.plugin.resourcegroups.db.ResourceGroupsDao;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class H2DaoProvider
implements Provider<ResourceGroupsDao> {
    private final H2ResourceGroupsDao dao;

    @Inject
    public H2DaoProvider(DbResourceGroupConfig config) {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(Objects.requireNonNull(config.getConfigDbUrl(), "resource-groups.config-db-url is null"));
        this.dao = (H2ResourceGroupsDao)Jdbi.create((DataSource)ds).installPlugin((JdbiPlugin)new SqlObjectPlugin()).open().attach(H2ResourceGroupsDao.class);
    }

    public H2ResourceGroupsDao get() {
        return this.dao;
    }
}

