/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups.db;

import io.prestosql.plugin.resourcegroups.db.ResourceGroupsDao;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface H2ResourceGroupsDao
extends ResourceGroupsDao {
    @SqlUpdate(value="INSERT INTO resource_groups_global_properties\n(name, value) VALUES (:name, :value)")
    public void insertResourceGroupsGlobalProperties(@Bind(value="name") String var1, @Bind(value="value") String var2);

    @SqlUpdate(value="UPDATE resource_groups_global_properties SET name = :name")
    public void updateResourceGroupsGlobalProperties(@Bind(value="name") String var1);

    @SqlUpdate(value="INSERT INTO resource_groups\n(resource_group_id, name, soft_memory_limit, max_queued, soft_concurrency_limit, hard_concurrency_limit, scheduling_policy, scheduling_weight, jmx_export, soft_cpu_limit, hard_cpu_limit, parent, environment)\nVALUES (:resource_group_id, :name, :soft_memory_limit, :max_queued, :soft_concurrency_limit, :hard_concurrency_limit, :scheduling_policy, :scheduling_weight, :jmx_export, :soft_cpu_limit, :hard_cpu_limit, :parent, :environment)")
    public void insertResourceGroup(@Bind(value="resource_group_id") long var1, @Bind(value="name") String var3, @Bind(value="soft_memory_limit") String var4, @Bind(value="max_queued") int var5, @Bind(value="soft_concurrency_limit") Integer var6, @Bind(value="hard_concurrency_limit") int var7, @Bind(value="scheduling_policy") String var8, @Bind(value="scheduling_weight") Integer var9, @Bind(value="jmx_export") Boolean var10, @Bind(value="soft_cpu_limit") String var11, @Bind(value="hard_cpu_limit") String var12, @Bind(value="parent") Long var13, @Bind(value="environment") String var14);

    @SqlUpdate(value="UPDATE resource_groups SET\n resource_group_id = :resource_group_id\n, name = :name\n, soft_memory_limit = :soft_memory_limit\n, max_queued = :max_queued\n, soft_concurrency_limit = :soft_concurrency_limit\n, hard_concurrency_limit = :hard_concurrency_limit\n, scheduling_policy = :scheduling_policy\n, scheduling_weight = :scheduling_weight\n, jmx_export = :jmx_export\n, soft_cpu_limit = :soft_cpu_limit\n, hard_cpu_limit = :hard_cpu_limit\n, parent = :parent\n, environment = :environment\nWHERE resource_group_id = :resource_group_id")
    public void updateResourceGroup(@Bind(value="resource_group_id") long var1, @Bind(value="name") String var3, @Bind(value="soft_memory_limit") String var4, @Bind(value="max_queued") int var5, @Bind(value="soft_concurrency_limit") Integer var6, @Bind(value="hard_concurrency_limit") int var7, @Bind(value="scheduling_policy") String var8, @Bind(value="scheduling_weight") Integer var9, @Bind(value="jmx_export") Boolean var10, @Bind(value="soft_cpu_limit") String var11, @Bind(value="hard_cpu_limit") String var12, @Bind(value="parent") Long var13, @Bind(value="environment") String var14);

    @SqlUpdate(value="DELETE FROM resource_groups WHERE resource_group_id = :resource_group_id")
    public void deleteResourceGroup(@Bind(value="resource_group_id") long var1);

    @SqlUpdate(value="INSERT INTO selectors\n(resource_group_id, priority, user_regex, source_regex, query_type, client_tags, selector_resource_estimate)\nVALUES (:resource_group_id, :priority, :user_regex, :source_regex, :query_type, :client_tags, :selector_resource_estimate)")
    public void insertSelector(@Bind(value="resource_group_id") long var1, @Bind(value="priority") long var3, @Bind(value="user_regex") String var5, @Bind(value="source_regex") String var6, @Bind(value="query_type") String var7, @Bind(value="client_tags") String var8, @Bind(value="selector_resource_estimate") String var9);

    @SqlUpdate(value="UPDATE selectors SET\n resource_group_id = :resource_group_id\n, user_regex = :user_regex\n, source_regex = :source_regex\n, client_tags = :client_tags\nWHERE resource_group_id = :resource_group_id\n AND ((user_regex IS NULL AND :old_user_regex IS NULL) OR user_regex = :old_user_regex)\n AND ((source_regex IS NULL AND :old_source_regex IS NULL) OR source_regex = :old_source_regex)\n AND ((client_tags IS NULL AND :old_client_tags IS NULL) OR client_tags = :old_client_tags)")
    public void updateSelector(@Bind(value="resource_group_id") long var1, @Bind(value="user_regex") String var3, @Bind(value="source_regex") String var4, @Bind(value="client_tags") String var5, @Bind(value="old_user_regex") String var6, @Bind(value="old_source_regex") String var7, @Bind(value="old_client_tags") String var8);

    @SqlUpdate(value="DELETE FROM selectors WHERE resource_group_id = :resource_group_id\n AND ((user_regex IS NULL AND :user_regex IS NULL) OR user_regex = :user_regex)\n AND ((source_regex IS NULL AND :source_regex IS NULL) OR source_regex = :source_regex)\n AND ((client_tags IS NULL AND :client_tags IS NULL) OR client_tags = :client_tags)")
    public void deleteSelector(@Bind(value="resource_group_id") long var1, @Bind(value="user_regex") String var3, @Bind(value="source_regex") String var4, @Bind(value="client_tags") String var5);

    @SqlUpdate(value="DELETE FROM selectors WHERE resource_group_id = :resource_group_id")
    public void deleteSelectors(@Bind(value="resource_group_id") long var1);

    @SqlUpdate(value="INSERT INTO exact_match_source_selectors (environment, source, query_type, update_time, resource_group_id)\nVALUES (:environment, :source, :query_type, now(), :resourceGroupId)\n")
    public void insertExactMatchSelector(@Bind(value="environment") String var1, @Bind(value="source") String var2, @Bind(value="query_type") String var3, @Bind(value="resourceGroupId") String var4);

    @SqlUpdate(value="DROP TABLE selectors")
    public void dropSelectorsTable();
}

