/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups.db;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.resourcegroups.db.DbResourceGroupConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestDbResourceGroupConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DbResourceGroupConfig)ConfigAssertions.recordDefaults(DbResourceGroupConfig.class)).setConfigDbUrl(null).setMaxRefreshInterval(new Duration(1.0, TimeUnit.HOURS)).setExactMatchSelectorEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"resource-groups.config-db-url", (Object)"jdbc:mysql://localhost:3306/config?user=presto_admin").put((Object)"resource-groups.max-refresh-interval", (Object)"1m").put((Object)"resource-groups.exact-match-selector-enabled", (Object)"true").build();
        DbResourceGroupConfig expected = new DbResourceGroupConfig().setConfigDbUrl("jdbc:mysql://localhost:3306/config?user=presto_admin").setMaxRefreshInterval(new Duration(1.0, TimeUnit.MINUTES)).setExactMatchSelectorEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

