/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups.db;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.execution.resourcegroups.InternalResourceGroup;
import io.prestosql.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.prestosql.plugin.resourcegroups.ResourceGroupSelector;
import io.prestosql.plugin.resourcegroups.StaticSelector;
import io.prestosql.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.prestosql.plugin.resourcegroups.db.DbResourceGroupConfigurationManager;
import io.prestosql.plugin.resourcegroups.db.DbSourceExactMatchSelector;
import io.prestosql.plugin.resourcegroups.db.H2DaoProvider;
import io.prestosql.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.prestosql.plugin.resourcegroups.db.ResourceGroupsDao;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.resourcegroups.ResourceGroup;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.resourcegroups.SchedulingPolicy;
import io.prestosql.spi.resourcegroups.SelectionContext;
import io.prestosql.spi.resourcegroups.SelectionCriteria;
import io.prestosql.spi.session.ResourceEstimates;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.h2.jdbc.JdbcException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDbResourceGroupConfigurationManager {
    private static final String ENVIRONMENT = "test";
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());

    static H2DaoProvider setup(String prefix) {
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl("jdbc:h2:mem:test_" + prefix + System.nanoTime() + ThreadLocalRandom.current().nextLong());
        return new H2DaoProvider(config);
    }

    @Test
    public void testEnvironments() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_configuration");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        String prodEnvironment = "prod";
        String devEnvironment = "dev";
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        dao.insertResourceGroup(1L, "prod_global", "10MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, prodEnvironment);
        dao.insertResourceGroup(2L, "dev_global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, devEnvironment);
        dao.insertSelector(1L, 1L, ".*prod_user.*", null, null, null, null);
        dao.insertSelector(2L, 2L, ".*dev_user.*", null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), prodEnvironment);
        List groups = manager.getRootGroups();
        Assert.assertEquals((int)groups.size(), (int)1);
        InternalResourceGroup prodGlobal = new InternalResourceGroup("prod_global", (group, export) -> {}, MoreExecutors.directExecutor());
        manager.configure((ResourceGroup)prodGlobal, new SelectionContext(prodGlobal.getId(), (Object)new ResourceGroupIdTemplate("prod_global")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(prodGlobal, "10MB", 1000, 100, 100, SchedulingPolicy.WEIGHTED, 1, true, java.time.Duration.ofHours(1L), java.time.Duration.ofDays(1L));
        Assert.assertEquals((int)manager.getSelectors().size(), (int)1);
        ResourceGroupSelector prodSelector = (ResourceGroupSelector)manager.getSelectors().get(0);
        ResourceGroupId prodResourceGroupId = ((SelectionContext)prodSelector.match(new SelectionCriteria(true, "prod_user", (Set)ImmutableSet.of(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty())).get()).getResourceGroupId();
        Assert.assertEquals((String)prodResourceGroupId.toString(), (String)"prod_global");
        manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), devEnvironment);
        Assert.assertEquals((int)groups.size(), (int)1);
        InternalResourceGroup devGlobal = new InternalResourceGroup("dev_global", (group, export) -> {}, MoreExecutors.directExecutor());
        manager.configure((ResourceGroup)devGlobal, new SelectionContext(prodGlobal.getId(), (Object)new ResourceGroupIdTemplate("dev_global")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(devGlobal, "1MB", 1000, 100, 100, SchedulingPolicy.WEIGHTED, 1, true, java.time.Duration.ofHours(1L), java.time.Duration.ofDays(1L));
        Assert.assertEquals((int)manager.getSelectors().size(), (int)1);
        ResourceGroupSelector devSelector = (ResourceGroupSelector)manager.getSelectors().get(0);
        ResourceGroupId devResourceGroupId = ((SelectionContext)devSelector.match(new SelectionCriteria(true, "dev_user", (Set)ImmutableSet.of(), Optional.empty(), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.empty())).get()).getResourceGroupId();
        Assert.assertEquals((String)devResourceGroupId.toString(), (String)"dev_global");
    }

    @Test
    public void testConfiguration() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_configuration");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "2MB", 4, 3, 3, null, 5, null, null, null, 1L, ENVIRONMENT);
        dao.insertSelector(2L, 1L, null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        AtomicBoolean exported = new AtomicBoolean();
        InternalResourceGroup global = new InternalResourceGroup("global", (group, export) -> exported.set((boolean)export), MoreExecutors.directExecutor());
        manager.configure((ResourceGroup)global, new SelectionContext(global.getId(), (Object)new ResourceGroupIdTemplate("global")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(global, "1MB", 1000, 100, 100, SchedulingPolicy.WEIGHTED, 1, true, java.time.Duration.ofHours(1L), java.time.Duration.ofDays(1L));
        exported.set(false);
        InternalResourceGroup sub = global.getOrCreateSubGroup("sub");
        manager.configure((ResourceGroup)sub, new SelectionContext(sub.getId(), (Object)new ResourceGroupIdTemplate("global.sub")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(sub, "2MB", 4, 3, 3, SchedulingPolicy.FAIR, 5, false, java.time.Duration.ofMillis(Long.MAX_VALUE), java.time.Duration.ofMillis(Long.MAX_VALUE));
    }

    @Test
    public void testDuplicates() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_dup_roots");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        try {
            dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
            Assert.fail((String)"Expected to fail");
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)(ex instanceof UnableToExecuteStatementException));
            Assert.assertTrue((boolean)(ex.getCause() instanceof JdbcException));
            Assert.assertTrue((boolean)ex.getCause().getMessage().startsWith("Unique index or primary key violation"));
        }
        dao.insertSelector(1L, 1L, null, null, null, null, null);
        daoProvider = TestDbResourceGroupConfigurationManager.setup("test_dup_subs");
        dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "1MB", 1000, 100, 100, null, null, null, null, null, 1L, ENVIRONMENT);
        try {
            dao.insertResourceGroup(2L, "sub", "1MB", 1000, 100, 100, null, null, null, null, null, 1L, ENVIRONMENT);
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)(ex instanceof UnableToExecuteStatementException));
            Assert.assertTrue((boolean)(ex.getCause() instanceof JdbcException));
            Assert.assertTrue((boolean)ex.getCause().getMessage().startsWith("Unique index or primary key violation"));
        }
        dao.insertSelector(2L, 2L, null, null, null, null, null);
    }

    @Test
    public void testMissing() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_missing");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "2MB", 4, 3, 3, null, 5, null, null, null, 1L, ENVIRONMENT);
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        dao.insertSelector(2L, 1L, null, null, null, null, null);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        InternalResourceGroup missing = new InternalResourceGroup("missing", (group, export) -> {}, MoreExecutors.directExecutor());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> manager.configure((ResourceGroup)missing, new SelectionContext(missing.getId(), (Object)new ResourceGroupIdTemplate("missing")))).isInstanceOf(IllegalStateException.class)).hasMessage("No matching configuration found for [missing] using [missing]");
    }

    @Test(timeOut=60000L)
    public void testReconfig() throws Exception {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_reconfig");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "2MB", 4, 3, 3, null, 5, null, null, null, 1L, ENVIRONMENT);
        dao.insertSelector(2L, 1L, null, null, null, null, null);
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        manager.start();
        AtomicBoolean exported = new AtomicBoolean();
        InternalResourceGroup global = new InternalResourceGroup("global", (group, export) -> exported.set((boolean)export), MoreExecutors.directExecutor());
        manager.configure((ResourceGroup)global, new SelectionContext(global.getId(), (Object)new ResourceGroupIdTemplate("global")));
        InternalResourceGroup globalSub = global.getOrCreateSubGroup("sub");
        manager.configure((ResourceGroup)globalSub, new SelectionContext(globalSub.getId(), (Object)new ResourceGroupIdTemplate("global.sub")));
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(globalSub, "2MB", 4, 3, 3, SchedulingPolicy.FAIR, 5, false, java.time.Duration.ofMillis(Long.MAX_VALUE), java.time.Duration.ofMillis(Long.MAX_VALUE));
        dao.updateResourceGroup(2L, "sub", "3MB", 2, 1, 1, "weighted", 6, true, "1h", "1d", 1L, ENVIRONMENT);
        do {
            TimeUnit.MILLISECONDS.sleep(500L);
        } while (!globalSub.getJmxExport());
        TestDbResourceGroupConfigurationManager.assertEqualsResourceGroup(globalSub, "3MB", 2, 1, 1, SchedulingPolicy.WEIGHTED, 6, true, java.time.Duration.ofHours(1L), java.time.Duration.ofDays(1L));
        dao.deleteSelectors(2L);
        dao.deleteResourceGroup(2L);
        do {
            TimeUnit.MILLISECONDS.sleep(500L);
        } while (globalSub.getMaxQueuedQueries() != 0 || globalSub.getHardConcurrencyLimit() != 0);
    }

    @Test
    public void testExactMatchSelector() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("test_exact_match_selector");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsGlobalPropertiesTable();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.createExactMatchSelectorsTable();
        dao.insertResourceGroup(1L, "global", "1MB", 1000, 100, 100, "weighted", null, true, "1h", "1d", null, ENVIRONMENT);
        dao.insertResourceGroup(2L, "sub", "2MB", 4, 3, 3, null, 5, null, null, null, 1L, ENVIRONMENT);
        dao.insertSelector(2L, 1L, null, null, null, null, null);
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        DbResourceGroupConfig config = new DbResourceGroupConfig();
        config.setExactMatchSelectorEnabled(true);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, config, (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        manager.load();
        Assert.assertEquals((int)manager.getSelectors().size(), (int)2);
        Assert.assertTrue((boolean)(manager.getSelectors().get(0) instanceof DbSourceExactMatchSelector));
        config.setExactMatchSelectorEnabled(false);
        manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, config, (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        manager.load();
        Assert.assertEquals((int)manager.getSelectors().size(), (int)1);
        Assert.assertFalse((boolean)(manager.getSelectors().get(0) instanceof DbSourceExactMatchSelector));
    }

    @Test
    public void testSelectorPriority() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        int numberOfUsers = 100;
        ArrayList<String> expectedUsers = new ArrayList<String>();
        int[] randomPriorities = ThreadLocalRandom.current().ints(0, 1000).distinct().limit(100L).toArray();
        for (int i = 0; i < 100; ++i) {
            int priority = randomPriorities[i];
            String user = String.valueOf(priority);
            dao.insertSelector(1L, priority, user, ".*", null, null, null);
            expectedUsers.add(user);
        }
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, new DbResourceGroupConfig(), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        manager.load();
        List selectors = manager.getSelectors();
        Assert.assertEquals((int)selectors.size(), (int)expectedUsers.size());
        expectedUsers.sort(Comparator.comparingInt(Integer::parseInt).reversed());
        for (int i = 0; i < 100; ++i) {
            Optional user = ((StaticSelector)selectors.get(i)).getUserRegex();
            Assert.assertTrue((boolean)user.isPresent());
            Assert.assertEquals((String)((Pattern)user.get()).pattern(), (String)((String)expectedUsers.get(i)));
        }
    }

    @Test
    public void testInvalidConfiguration() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, new DbResourceGroupConfig().setMaxRefreshInterval(Duration.valueOf((String)"1ms")), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DbResourceGroupConfigurationManager)manager).getSelectors()).isInstanceOf(PrestoException.class)).hasMessage("No selectors are configured");
    }

    @Test
    public void testRefreshInterval() {
        H2DaoProvider daoProvider = TestDbResourceGroupConfigurationManager.setup("selectors");
        H2ResourceGroupsDao dao = daoProvider.get();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.insertResourceGroup(1L, "global", "100%", 100, 100, 100, null, null, null, null, null, null, ENVIRONMENT);
        DbResourceGroupConfigurationManager manager = new DbResourceGroupConfigurationManager((poolId, listener) -> {}, new DbResourceGroupConfig().setMaxRefreshInterval(Duration.valueOf((String)"1ms")), (ResourceGroupsDao)daoProvider.get(), ENVIRONMENT);
        dao.dropSelectorsTable();
        manager.load();
        try {
            manager.getSelectors();
            Assert.fail((String)"Expected unavailable configuration exception");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Selectors cannot be fetched from database");
        }
        try {
            manager.getRootGroups();
            Assert.fail((String)"Expected unavailable configuration exception");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Root groups cannot be fetched from database");
        }
        manager.destroy();
    }

    private static void assertEqualsResourceGroup(InternalResourceGroup group, String softMemoryLimit, int maxQueued, int hardConcurrencyLimit, int softConcurrencyLimit, SchedulingPolicy schedulingPolicy, int schedulingWeight, boolean jmxExport, java.time.Duration softCpuLimit, java.time.Duration hardCpuLimit) {
        Assert.assertEquals((long)group.getSoftMemoryLimitBytes(), (long)DataSize.valueOf((String)softMemoryLimit).toBytes());
        Assert.assertEquals((int)group.getMaxQueuedQueries(), (int)maxQueued);
        Assert.assertEquals((int)group.getHardConcurrencyLimit(), (int)hardConcurrencyLimit);
        Assert.assertEquals((int)group.getSoftConcurrencyLimit(), (int)softConcurrencyLimit);
        Assert.assertEquals((Object)group.getSchedulingPolicy(), (Object)schedulingPolicy);
        Assert.assertEquals((int)group.getSchedulingWeight(), (int)schedulingWeight);
        Assert.assertEquals((boolean)group.getJmxExport(), (boolean)jmxExport);
        Assert.assertEquals((Object)group.getSoftCpuLimit(), (Object)softCpuLimit);
        Assert.assertEquals((Object)group.getHardCpuLimit(), (Object)hardCpuLimit);
    }
}

