/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.resourcegroups.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.prestosql.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.prestosql.plugin.resourcegroups.db.DbSourceExactMatchSelector;
import io.prestosql.plugin.resourcegroups.db.H2DaoProvider;
import io.prestosql.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.prestosql.plugin.resourcegroups.db.ResourceGroupsDao;
import io.prestosql.spi.resourcegroups.QueryType;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.resourcegroups.SelectionContext;
import io.prestosql.spi.resourcegroups.SelectionCriteria;
import io.prestosql.spi.session.ResourceEstimates;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDbSourceExactMatchSelector {
    private static final JsonCodec<ResourceGroupId> CODEC = JsonCodec.jsonCodec(ResourceGroupId.class);
    private static final ResourceEstimates EMPTY_RESOURCE_ESTIMATES = new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty());
    private H2ResourceGroupsDao dao;

    @BeforeClass
    public void setup() {
        DbResourceGroupConfig config = new DbResourceGroupConfig().setConfigDbUrl("jdbc:h2:mem:test_db-exact-match-selector" + System.nanoTime() + ThreadLocalRandom.current().nextLong());
        this.dao = new H2DaoProvider(config).get();
        this.dao.createExactMatchSelectorsTable();
    }

    @Test
    public void testMatch() {
        ResourceGroupId resourceGroupId1 = new ResourceGroupId((List)ImmutableList.of((Object)"global", (Object)"test", (Object)"user", (Object)"insert"));
        ResourceGroupId resourceGroupId2 = new ResourceGroupId((List)ImmutableList.of((Object)"global", (Object)"test", (Object)"user", (Object)"select"));
        this.dao.insertExactMatchSelector("test", "@test@test_pipeline", QueryType.INSERT.name(), CODEC.toJson((Object)resourceGroupId1));
        this.dao.insertExactMatchSelector("test", "@test@test_pipeline", QueryType.SELECT.name(), CODEC.toJson((Object)resourceGroupId2));
        DbSourceExactMatchSelector selector = new DbSourceExactMatchSelector("test", (ResourceGroupsDao)this.dao);
        Assert.assertEquals((Object)selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), Optional.of("@test@test_pipeline"), (Set)ImmutableSet.of((Object)"tag"), EMPTY_RESOURCE_ESTIMATES, Optional.empty())), Optional.empty());
        Assert.assertEquals(selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), Optional.of("@test@test_pipeline"), (Set)ImmutableSet.of((Object)"tag"), EMPTY_RESOURCE_ESTIMATES, Optional.of(QueryType.INSERT.name()))).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId1));
        Assert.assertEquals(selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), Optional.of("@test@test_pipeline"), (Set)ImmutableSet.of((Object)"tag"), EMPTY_RESOURCE_ESTIMATES, Optional.of(QueryType.SELECT.name()))).map(SelectionContext::getResourceGroupId), Optional.of(resourceGroupId2));
        Assert.assertEquals((Object)selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), Optional.of("@test@test_pipeline"), (Set)ImmutableSet.of((Object)"tag"), EMPTY_RESOURCE_ESTIMATES, Optional.of(QueryType.DELETE.name()))), Optional.empty());
        Assert.assertEquals((Object)selector.match(new SelectionCriteria(true, "testuser", (Set)ImmutableSet.of(), Optional.of("@test@test_new"), (Set)ImmutableSet.of(), EMPTY_RESOURCE_ESTIMATES, Optional.of(QueryType.INSERT.name()))), Optional.empty());
    }
}

