/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.prestosql.spi.block.AbstractArrayBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import java.util.Objects;

public class ColumnarArray {
    private final Block nullCheckBlock;
    private final int offsetsOffset;
    private final int[] offsets;
    private final Block elementsBlock;

    public static ColumnarArray toColumnarArray(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (block instanceof DictionaryBlock) {
            return ColumnarArray.toColumnarArray((DictionaryBlock)block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            return ColumnarArray.toColumnarArray((RunLengthEncodedBlock)block);
        }
        if (!(block instanceof AbstractArrayBlock)) {
            throw new IllegalArgumentException("Invalid array block: " + block.getClass().getName());
        }
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        Block elementsBlock = arrayBlock.getRawElementBlock();
        int elementsOffset = 0;
        int elementsLength = 0;
        if (arrayBlock.getPositionCount() > 0) {
            elementsOffset = arrayBlock.getOffset(0);
            elementsLength = arrayBlock.getOffset(arrayBlock.getPositionCount()) - elementsOffset;
        }
        elementsBlock = elementsBlock.getRegion(elementsOffset, elementsLength);
        return new ColumnarArray(block, arrayBlock.getOffsetBase(), arrayBlock.getOffsets(), elementsBlock);
    }

    private static ColumnarArray toColumnarArray(DictionaryBlock dictionaryBlock) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray(dictionaryBlock.getDictionary());
        int[] offsets = new int[dictionaryBlock.getPositionCount() + 1];
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            int dictionaryId = dictionaryBlock.getId(position);
            offsets[position + 1] = offsets[position] + columnarArray.getLength(dictionaryId);
        }
        int[] dictionaryIds = new int[offsets[dictionaryBlock.getPositionCount()]];
        int nextDictionaryIndex = 0;
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            int dictionaryId = dictionaryBlock.getId(position);
            int length = columnarArray.getLength(dictionaryId);
            int startOffset = columnarArray.getOffset(dictionaryId) - columnarArray.getOffset(0);
            for (int entryIndex = 0; entryIndex < length; ++entryIndex) {
                dictionaryIds[nextDictionaryIndex] = startOffset + entryIndex;
                ++nextDictionaryIndex;
            }
        }
        return new ColumnarArray(dictionaryBlock, 0, offsets, new DictionaryBlock(dictionaryIds.length, columnarArray.getElementsBlock(), dictionaryIds));
    }

    private static ColumnarArray toColumnarArray(RunLengthEncodedBlock rleBlock) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray(rleBlock.getValue());
        int[] offsets = new int[rleBlock.getPositionCount() + 1];
        int valueLength = columnarArray.getLength(0);
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = i * valueLength;
        }
        int[] dictionaryIds = new int[rleBlock.getPositionCount() * valueLength];
        int nextDictionaryIndex = 0;
        for (int position = 0; position < rleBlock.getPositionCount(); ++position) {
            int entryIndex = 0;
            while (entryIndex < valueLength) {
                dictionaryIds[nextDictionaryIndex] = entryIndex++;
                ++nextDictionaryIndex;
            }
        }
        return new ColumnarArray(rleBlock, 0, offsets, new DictionaryBlock(dictionaryIds.length, columnarArray.getElementsBlock(), dictionaryIds));
    }

    private ColumnarArray(Block nullCheckBlock, int offsetsOffset, int[] offsets, Block elementsBlock) {
        this.nullCheckBlock = nullCheckBlock;
        this.offsetsOffset = offsetsOffset;
        this.offsets = offsets;
        this.elementsBlock = elementsBlock;
    }

    public int getPositionCount() {
        return this.nullCheckBlock.getPositionCount();
    }

    public boolean isNull(int position) {
        return this.nullCheckBlock.isNull(position);
    }

    public int getLength(int position) {
        return this.getOffset(position + 1) - this.getOffset(position);
    }

    private int getOffset(int position) {
        return this.offsets[position + this.offsetsOffset];
    }

    public Block getElementsBlock() {
        return this.elementsBlock;
    }
}

