/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.SizeOf;
import io.prestosql.spi.block.AbstractMapBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.MapBlockBuilder;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class MapBlock
extends AbstractMapBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlock.class).instanceSize();
    private final int startOffset;
    private final int positionCount;
    private final boolean[] mapIsNull;
    private final int[] offsets;
    private final Block keyBlock;
    private final Block valueBlock;
    private final int[] hashTables;
    private volatile long sizeInBytes;
    private final long retainedSizeInBytes;

    public static MapBlock fromKeyValueBlock(Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, MapType mapType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode) {
        MapBlock.validateConstructorArguments(0, offsets.length - 1, mapIsNull.orElse(null), offsets, keyBlock, valueBlock, mapType.getKeyType(), keyBlockNativeEquals, keyNativeHashCode);
        int mapCount = offsets.length - 1;
        int elementCount = keyBlock.getPositionCount();
        int[] hashTables = new int[elementCount * 2];
        Arrays.fill(hashTables, -1);
        for (int i = 0; i < mapCount; ++i) {
            int keyOffset = offsets[i];
            int keyCount = offsets[i + 1] - keyOffset;
            if (keyCount < 0) {
                throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, offsets[i], i + 1, offsets[i + 1]));
            }
            if (mapIsNull.isPresent() && mapIsNull.get()[i] && keyCount != 0) {
                throw new IllegalArgumentException("A null map must have zero entries");
            }
            MapBlockBuilder.buildHashTable(keyBlock, keyOffset, keyCount, keyBlockHashCode, hashTables, keyOffset * 2, keyCount * 2);
        }
        return MapBlock.createMapBlockInternal(0, mapCount, mapIsNull, offsets, keyBlock, valueBlock, hashTables, mapType.getKeyType(), keyBlockNativeEquals, keyNativeHashCode);
    }

    public static MapBlock createMapBlockInternal(int startOffset, int positionCount, Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, int[] hashTables, Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode) {
        MapBlock.validateConstructorArguments(startOffset, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock, keyType, keyBlockNativeEquals, keyNativeHashCode);
        return new MapBlock(startOffset, positionCount, mapIsNull.orElse(null), offsets, keyBlock, valueBlock, hashTables, keyType, keyBlockNativeEquals, keyNativeHashCode);
    }

    private static void validateConstructorArguments(int startOffset, int positionCount, @Nullable boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("startOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (mapIsNull != null && mapIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        Objects.requireNonNull(offsets, "offsets is null");
        if (offsets.length - startOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        Objects.requireNonNull(keyBlock, "keyBlock is null");
        Objects.requireNonNull(valueBlock, "valueBlock is null");
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("keyBlock and valueBlock has different size: %s %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(keyBlockNativeEquals, "keyBlockNativeEquals is null");
        Objects.requireNonNull(keyNativeHashCode, "keyNativeHashCode is null");
    }

    private MapBlock(int startOffset, int positionCount, @Nullable boolean[] mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, int[] hashTables, Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyNativeHashCode) {
        super(keyType, keyNativeHashCode, keyBlockNativeEquals);
        Objects.requireNonNull(hashTables, "hashTables is null");
        if (hashTables.length < keyBlock.getPositionCount() * 2) {
            throw new IllegalArgumentException(String.format("keyBlock/valueBlock size does not match hash table size: %s %s", keyBlock.getPositionCount(), hashTables.length));
        }
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.mapIsNull = mapIsNull;
        this.offsets = offsets;
        this.keyBlock = keyBlock;
        this.valueBlock = valueBlock;
        this.hashTables = hashTables;
        this.sizeInBytes = -1L;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + keyBlock.getRetainedSizeInBytes() + valueBlock.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])offsets) + SizeOf.sizeOf((boolean[])mapIsNull) + SizeOf.sizeOf((int[])hashTables);
    }

    @Override
    protected Block getRawKeyBlock() {
        return this.keyBlock;
    }

    @Override
    protected Block getRawValueBlock() {
        return this.valueBlock;
    }

    @Override
    protected int[] getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    @Nullable
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private void calculateSize() {
        int entriesStart = this.offsets[this.startOffset];
        int entriesEnd = this.offsets[this.startOffset + this.positionCount];
        int entryCount = entriesEnd - entriesStart;
        this.sizeInBytes = this.keyBlock.getRegionSizeInBytes(entriesStart, entryCount) + this.valueBlock.getRegionSizeInBytes(entriesStart, entryCount) + 5L * (long)this.positionCount + 8L * (long)entryCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.keyBlock, this.keyBlock.getRetainedSizeInBytes());
        consumer.accept(this.valueBlock, this.valueBlock.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        consumer.accept(this.mapIsNull, SizeOf.sizeOf((boolean[])this.mapIsNull));
        consumer.accept(this.hashTables, SizeOf.sizeOf((int[])this.hashTables));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MapBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Block getLoadedBlock() {
        if (this.keyBlock != this.keyBlock.getLoadedBlock()) {
            throw new IllegalStateException();
        }
        Block loadedValueBlock = this.valueBlock.getLoadedBlock();
        if (loadedValueBlock == this.valueBlock) {
            return this;
        }
        return MapBlock.createMapBlockInternal(this.startOffset, this.positionCount, Optional.ofNullable(this.mapIsNull), this.offsets, this.keyBlock, loadedValueBlock, this.hashTables, this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode);
    }
}

