/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class Constraint {
    private final TupleDomain<ColumnHandle> summary;
    private final Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate;

    public static Constraint alwaysTrue() {
        return new Constraint(TupleDomain.all(), Optional.empty());
    }

    public static Constraint alwaysFalse() {
        return new Constraint(TupleDomain.none(), Optional.of(bindings -> false));
    }

    public Constraint(TupleDomain<ColumnHandle> summary) {
        this(summary, Optional.empty());
    }

    public Constraint(TupleDomain<ColumnHandle> summary, Predicate<Map<ColumnHandle, NullableValue>> predicate) {
        this(summary, Optional.of(predicate));
    }

    public Constraint(TupleDomain<ColumnHandle> summary, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        Objects.requireNonNull(summary, "summary is null");
        Objects.requireNonNull(predicate, "predicate is null");
        this.summary = summary;
        this.predicate = predicate;
    }

    public TupleDomain<ColumnHandle> getSummary() {
        return this.summary;
    }

    public Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate() {
        return this.predicate;
    }
}

