/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector.classloader;

import io.airlift.slice.Slice;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorResolvedIndex;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableLayoutResult;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.LimitApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.GrantInfo;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.statistics.TableStatisticsMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public class ClassLoaderSafeConnectorMetadata
implements ConnectorMetadata {
    private final ConnectorMetadata delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorMetadata(ConnectorMetadata delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<ConnectorTableLayoutResult> list = this.delegate.getTableLayouts(session, table, constraint, desiredColumns);
            return list;
        }
    }

    @Override
    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableLayout connectorTableLayout = this.delegate.getTableLayout(session, handle);
            return connectorTableLayout;
        }
    }

    @Override
    public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<ConnectorPartitioningHandle> optional = this.delegate.getCommonPartitioningHandle(session, left, right);
            return optional;
        }
    }

    @Override
    public ConnectorTableLayoutHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableLayoutHandle tableLayoutHandle, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableLayoutHandle connectorTableLayoutHandle = this.delegate.makeCompatiblePartitioning(session, tableLayoutHandle, partitioningHandle);
            return connectorTableLayoutHandle;
        }
    }

    @Override
    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<ConnectorNewTableLayout> optional = this.delegate.getNewTableLayout(session, tableMetadata);
            return optional;
        }
    }

    @Override
    public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<ConnectorNewTableLayout> optional = this.delegate.getInsertLayout(session, tableHandle);
            return optional;
        }
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatisticsMetadata tableStatisticsMetadata = this.delegate.getStatisticsCollectionMetadataForWrite(session, tableMetadata);
            return tableStatisticsMetadata;
        }
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatisticsMetadata tableStatisticsMetadata = this.delegate.getStatisticsCollectionMetadata(session, tableMetadata);
            return tableStatisticsMetadata;
        }
    }

    @Override
    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginStatisticsCollection(session, tableHandle);
            return connectorTableHandle;
        }
    }

    @Override
    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.finishStatisticsCollection(session, tableHandle, computedStatistics);
        }
    }

    @Override
    public boolean schemaExists(ConnectorSession session, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.schemaExists(session, schemaName);
            return bl;
        }
    }

    @Override
    public List<String> listSchemaNames(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<String> list = this.delegate.listSchemaNames(session);
            return list;
        }
    }

    @Override
    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.getTableHandle(session, tableName);
            return connectorTableHandle;
        }
    }

    @Override
    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.getTableHandleForStatisticsCollection(session, tableName, analyzeProperties);
            return connectorTableHandle;
        }
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<SystemTable> optional = this.delegate.getSystemTable(session, tableName);
            return optional;
        }
    }

    @Override
    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableMetadata connectorTableMetadata = this.delegate.getTableMetadata(session, table);
            return connectorTableMetadata;
        }
    }

    @Override
    public Optional<Object> getInfo(ConnectorTableLayoutHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<Object> optional = this.delegate.getInfo(table);
            return optional;
        }
    }

    @Override
    public Optional<Object> getInfo(ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<Object> optional = this.delegate.getInfo(table);
            return optional;
        }
    }

    @Override
    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<SchemaTableName> list = this.delegate.listTables(session, schemaName);
            return list;
        }
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map<String, ColumnHandle> map = this.delegate.getColumnHandles(session, tableHandle);
            return map;
        }
    }

    @Override
    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnMetadata columnMetadata = this.delegate.getColumnMetadata(session, tableHandle, columnHandle);
            return columnMetadata;
        }
    }

    @Override
    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map<SchemaTableName, List<ColumnMetadata>> map = this.delegate.listTableColumns(session, prefix);
            return map;
        }
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            TableStatistics tableStatistics = this.delegate.getTableStatistics(session, tableHandle, constraint);
            return tableStatistics;
        }
    }

    @Override
    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.addColumn(session, tableHandle, column);
        }
    }

    @Override
    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createSchema(session, schemaName, properties);
        }
    }

    @Override
    public void dropSchema(ConnectorSession session, String schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropSchema(session, schemaName);
        }
    }

    @Override
    public void renameSchema(ConnectorSession session, String source, String target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameSchema(session, source, target);
        }
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createTable(session, tableMetadata, ignoreExisting);
        }
    }

    @Override
    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropTable(session, tableHandle);
        }
    }

    @Override
    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameColumn(session, tableHandle, source, target);
        }
    }

    @Override
    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropColumn(session, tableHandle, column);
        }
    }

    @Override
    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.renameTable(session, tableHandle, newTableName);
        }
    }

    @Override
    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.setTableComment(session, tableHandle, comment);
        }
    }

    @Override
    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorOutputTableHandle connectorOutputTableHandle = this.delegate.beginCreateTable(session, tableMetadata, layout);
            return connectorOutputTableHandle;
        }
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<ConnectorOutputMetadata> optional = this.delegate.finishCreateTable(session, tableHandle, fragments, computedStatistics);
            return optional;
        }
    }

    @Override
    public void beginQuery(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.beginQuery(session);
        }
    }

    @Override
    public void cleanupQuery(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.cleanupQuery(session);
        }
    }

    @Override
    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorInsertTableHandle connectorInsertTableHandle = this.delegate.beginInsert(session, tableHandle);
            return connectorInsertTableHandle;
        }
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<ConnectorOutputMetadata> optional = this.delegate.finishInsert(session, insertHandle, fragments, computedStatistics);
            return optional;
        }
    }

    @Override
    public void createView(ConnectorSession session, SchemaTableName viewName, String viewData, boolean replace) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createView(session, viewName, viewData, replace);
        }
    }

    @Override
    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropView(session, viewName);
        }
    }

    @Override
    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<SchemaTableName> list = this.delegate.listViews(session, schemaName);
            return list;
        }
    }

    @Override
    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Map<SchemaTableName, ConnectorViewDefinition> map = this.delegate.getViews(session, prefix);
            return map;
        }
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ColumnHandle columnHandle = this.delegate.getUpdateRowIdColumnHandle(session, tableHandle);
            return columnHandle;
        }
    }

    @Override
    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableHandle connectorTableHandle = this.delegate.beginDelete(session, tableHandle);
            return connectorTableHandle;
        }
    }

    @Override
    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.finishDelete(session, tableHandle, fragments);
        }
    }

    @Override
    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.supportsMetadataDelete(session, tableHandle, tableLayoutHandle);
            return bl;
        }
    }

    @Override
    public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            OptionalLong optionalLong = this.delegate.metadataDelete(session, tableHandle, tableLayoutHandle);
            return optionalLong;
        }
    }

    @Override
    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<ConnectorResolvedIndex> optional = this.delegate.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain);
            return optional;
        }
    }

    @Override
    public void createRole(ConnectorSession session, String role, Optional<PrestoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.createRole(session, role, grantor);
        }
    }

    @Override
    public void dropRole(ConnectorSession session, String role) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.dropRole(session, role);
        }
    }

    @Override
    public Set<String> listRoles(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set<String> set = this.delegate.listRoles(session);
            return set;
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(ConnectorSession session, PrestoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set<RoleGrant> set = this.delegate.listRoleGrants(session, principal);
            return set;
        }
    }

    @Override
    public void grantRoles(ConnectorSession connectorSession, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.grantRoles(connectorSession, roles, grantees, withAdminOption, grantor);
        }
    }

    @Override
    public void revokeRoles(ConnectorSession connectorSession, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.revokeRoles(connectorSession, roles, grantees, adminOptionFor, grantor);
        }
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, PrestoPrincipal principal) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set<RoleGrant> set = this.delegate.listApplicableRoles(session, principal);
            return set;
        }
    }

    @Override
    public Set<String> listEnabledRoles(ConnectorSession session) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Set<String> set = this.delegate.listEnabledRoles(session);
            return set;
        }
    }

    @Override
    public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    @Override
    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.revokeTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    @Override
    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix prefix) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<GrantInfo> list = this.delegate.listTablePrivileges(session, prefix);
            return list;
        }
    }

    @Override
    public boolean usesLegacyTableLayouts() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.usesLegacyTableLayouts();
            return bl;
        }
    }

    @Override
    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableProperties connectorTableProperties = this.delegate.getTableProperties(session, table);
            return connectorTableProperties;
        }
    }

    @Override
    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<LimitApplicationResult<ConnectorTableHandle>> optional = this.delegate.applyLimit(session, table, limit);
            return optional;
        }
    }

    @Override
    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Optional<ConstraintApplicationResult<ConnectorTableHandle>> optional = this.delegate.applyFilter(session, table, constraint);
            return optional;
        }
    }
}

