/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class TupleDomain<T> {
    private final Optional<Map<T, Domain>> domains;

    private TupleDomain(Optional<Map<T, Domain>> domains) {
        Objects.requireNonNull(domains, "domains is null");
        this.domains = domains.flatMap(map -> {
            if (TupleDomain.containsNoneDomain(map)) {
                return Optional.empty();
            }
            return Optional.of(Collections.unmodifiableMap(TupleDomain.normalizeAndCopy(map)));
        });
    }

    public static <T> TupleDomain<T> withColumnDomains(Map<T, Domain> domains) {
        return new TupleDomain<T>(Optional.of(Objects.requireNonNull(domains, "domains is null")));
    }

    public static <T> TupleDomain<T> none() {
        return new TupleDomain<T>(Optional.empty());
    }

    public static <T> TupleDomain<T> all() {
        return TupleDomain.withColumnDomains(Collections.emptyMap());
    }

    public static <T> Optional<Map<T, NullableValue>> extractFixedValues(TupleDomain<T> tupleDomain) {
        if (!tupleDomain.getDomains().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(tupleDomain.getDomains().get().entrySet().stream().filter(entry -> ((Domain)entry.getValue()).isNullableSingleValue()).collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> new NullableValue(((Domain)entry.getValue()).getType(), ((Domain)entry.getValue()).getNullableSingleValue()))));
    }

    public static <T> TupleDomain<T> fromFixedValues(Map<T, NullableValue> fixedValues) {
        return TupleDomain.withColumnDomains(fixedValues.entrySet().stream().collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> {
            Type type = ((NullableValue)entry.getValue()).getType();
            Object value = ((NullableValue)entry.getValue()).getValue();
            return value == null ? Domain.onlyNull(type) : Domain.singleValue(type, value);
        })));
    }

    @JsonCreator
    public static <T> TupleDomain<T> fromColumnDomains(@JsonProperty(value="columnDomains") Optional<List<ColumnDomain<T>>> columnDomains) {
        if (!columnDomains.isPresent()) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(columnDomains.get().stream().collect(TupleDomain.toLinkedMap(ColumnDomain::getColumn, ColumnDomain::getDomain)));
    }

    @JsonProperty
    public Optional<List<ColumnDomain<T>>> getColumnDomains() {
        return this.domains.map(map -> map.entrySet().stream().map(entry -> new ColumnDomain(entry.getKey(), (Domain)entry.getValue())).collect(Collectors.toList()));
    }

    private static <T> boolean containsNoneDomain(Map<T, Domain> domains) {
        return domains.values().stream().anyMatch(Domain::isNone);
    }

    private static <T> Map<T, Domain> normalizeAndCopy(Map<T, Domain> domains) {
        return domains.entrySet().stream().filter(entry -> !((Domain)entry.getValue()).isAll()).collect(TupleDomain.toLinkedMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean isAll() {
        return this.domains.isPresent() && this.domains.get().isEmpty();
    }

    public boolean isNone() {
        return !this.domains.isPresent();
    }

    @JsonIgnore
    public Optional<Map<T, Domain>> getDomains() {
        return this.domains;
    }

    public TupleDomain<T> intersect(TupleDomain<T> other) {
        if (this.isNone() || other.isNone()) {
            return TupleDomain.none();
        }
        LinkedHashMap<T, Domain> intersected = new LinkedHashMap<T, Domain>(this.getDomains().get());
        for (Map.Entry<T, Domain> entry : other.getDomains().get().entrySet()) {
            Domain intersectionDomain = (Domain)intersected.get(entry.getKey());
            if (intersectionDomain == null) {
                intersected.put(entry.getKey(), entry.getValue());
                continue;
            }
            intersected.put(entry.getKey(), intersectionDomain.intersect(entry.getValue()));
        }
        return TupleDomain.withColumnDomains(intersected);
    }

    @SafeVarargs
    public static <T> TupleDomain<T> columnWiseUnion(TupleDomain<T> first, TupleDomain<T> second, TupleDomain<T> ... rest) {
        ArrayList<TupleDomain<T>> domains = new ArrayList<TupleDomain<T>>(rest.length + 2);
        domains.add(first);
        domains.add(second);
        domains.addAll(Arrays.asList(rest));
        return TupleDomain.columnWiseUnion(domains);
    }

    public static <T> TupleDomain<T> columnWiseUnion(List<TupleDomain<T>> tupleDomains) {
        TupleDomain<T> domain;
        if (tupleDomains.isEmpty()) {
            throw new IllegalArgumentException("tupleDomains must have at least one element");
        }
        if (tupleDomains.size() == 1) {
            return tupleDomains.get(0);
        }
        HashSet<T> commonColumns = new HashSet<T>();
        boolean found = false;
        Iterator<TupleDomain<T>> domains = tupleDomains.iterator();
        while (domains.hasNext()) {
            domain = domains.next();
            if (domain.isNone()) continue;
            found = true;
            commonColumns.addAll(domain.getDomains().get().keySet());
            break;
        }
        if (!found) {
            return TupleDomain.none();
        }
        while (domains.hasNext()) {
            domain = domains.next();
            if (domain.isNone()) continue;
            commonColumns.retainAll(domain.getDomains().get().keySet());
        }
        LinkedHashMap<T, ArrayList<Domain>> domainsByColumn = new LinkedHashMap<T, ArrayList<Domain>>(tupleDomains.size());
        for (TupleDomain<T> domain2 : tupleDomains) {
            if (domain2.isNone()) continue;
            for (Map.Entry<T, Domain> entry : domain2.getDomains().get().entrySet()) {
                if (!commonColumns.contains(entry.getKey())) continue;
                ArrayList<Domain> domainForColumn = (ArrayList<Domain>)domainsByColumn.get(entry.getKey());
                if (domainForColumn == null) {
                    domainForColumn = new ArrayList<Domain>();
                    domainsByColumn.put(entry.getKey(), domainForColumn);
                }
                domainForColumn.add(entry.getValue());
            }
        }
        LinkedHashMap result = new LinkedHashMap(domainsByColumn.size());
        for (Map.Entry entry : domainsByColumn.entrySet()) {
            result.put(entry.getKey(), Domain.union((List)entry.getValue()));
        }
        return TupleDomain.withColumnDomains(result);
    }

    public boolean overlaps(TupleDomain<T> other) {
        return !this.intersect(other).isNone();
    }

    public boolean contains(TupleDomain<T> other) {
        return other.isNone() || TupleDomain.columnWiseUnion(this, other, new TupleDomain[0]).equals(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TupleDomain other = (TupleDomain)obj;
        return Objects.equals(this.domains, other.domains);
    }

    public int hashCode() {
        return Objects.hash(this.domains);
    }

    public String toString() {
        if (this.isAll()) {
            return "TupleDomain{ALL}";
        }
        if (this.isNone()) {
            return "TupleDomain{NONE}";
        }
        return "TupleDomain{...}";
    }

    public String toString(ConnectorSession session) {
        StringBuilder buffer = new StringBuilder();
        if (this.isAll()) {
            buffer.append("ALL");
        } else if (this.isNone()) {
            buffer.append("NONE");
        } else {
            buffer.append(this.domains.get().entrySet().stream().collect(TupleDomain.toLinkedMap(Map.Entry::getKey, entry -> ((Domain)entry.getValue()).toString(session))));
        }
        return buffer.toString();
    }

    public <U> TupleDomain<U> transform(Function<T, U> function) {
        if (!this.domains.isPresent()) {
            return TupleDomain.none();
        }
        LinkedHashMap<U, Domain> result = new LinkedHashMap<U, Domain>(this.domains.get().size());
        for (Map.Entry<T, Domain> entry : this.domains.get().entrySet()) {
            Domain previous;
            U key = function.apply(entry.getKey());
            if (key == null || (previous = result.put(key, entry.getValue())) == null) continue;
            throw new IllegalArgumentException(String.format("Every argument must have a unique mapping. %s maps to %s and %s", entry.getKey(), entry.getValue(), previous));
        }
        return TupleDomain.withColumnDomains(result);
    }

    public TupleDomain<T> simplify() {
        if (this.isNone()) {
            return this;
        }
        Map<Object, Domain> simplified = this.domains.get().entrySet().stream().collect(TupleDomain.toLinkedMap(Map.Entry::getKey, e -> ((Domain)e.getValue()).simplify()));
        return TupleDomain.withColumnDomains(simplified);
    }

    private static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate values for a key: %s and %s", u, v));
        }, LinkedHashMap::new);
    }

    public static class ColumnDomain<C> {
        private final C column;
        private final Domain domain;

        @JsonCreator
        public ColumnDomain(@JsonProperty(value="column") C column, @JsonProperty(value="domain") Domain domain) {
            this.column = Objects.requireNonNull(column, "column is null");
            this.domain = Objects.requireNonNull(domain, "domain is null");
        }

        @JsonProperty
        public C getColumn() {
            return this.column;
        }

        @JsonProperty
        public Domain getDomain() {
            return this.domain;
        }
    }
}

