/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.security;

import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.SelectedRole;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Identity {
    private final String user;
    private final Optional<Principal> principal;
    private final Map<String, SelectedRole> roles;
    private final Map<String, String> extraCredentials;

    public Identity(String user, Optional<Principal> principal) {
        this(user, principal, Collections.emptyMap());
    }

    public Identity(String user, Optional<Principal> principal, Map<String, SelectedRole> roles) {
        this(user, principal, roles, Collections.emptyMap());
    }

    public Identity(String user, Optional<Principal> principal, Map<String, SelectedRole> roles, Map<String, String> extraCredentials) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.roles = Collections.unmodifiableMap(Objects.requireNonNull(roles, "roles is null"));
        this.extraCredentials = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null")));
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Map<String, SelectedRole> getRoles() {
        return this.roles;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public ConnectorIdentity toConnectorIdentity() {
        return new ConnectorIdentity(this.user, this.principal, Optional.empty(), this.extraCredentials);
    }

    public ConnectorIdentity toConnectorIdentity(String catalog) {
        Objects.requireNonNull(catalog, "catalog is null");
        return new ConnectorIdentity(this.user, this.principal, Optional.ofNullable(this.roles.get(catalog)), this.extraCredentials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.user, identity.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Identity{");
        sb.append("user='").append(this.user).append('\'');
        this.principal.ifPresent(principal -> sb.append(", principal=").append(principal));
        sb.append(", roles=").append(this.roles);
        sb.append(", extraCredentials=").append(this.extraCredentials.keySet());
        sb.append('}');
        return sb.toString();
    }
}

