/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.prestosql.spi.type.TimeZoneKey;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;

public final class SqlTime {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private final long millis;
    private final Optional<TimeZoneKey> sessionTimeZoneKey;

    public SqlTime(long millis) {
        this.millis = millis;
        this.sessionTimeZoneKey = Optional.empty();
    }

    @Deprecated
    public SqlTime(long millisUtc, TimeZoneKey sessionTimeZoneKey) {
        this.millis = millisUtc;
        this.sessionTimeZoneKey = Optional.of(sessionTimeZoneKey);
    }

    public long getMillis() {
        SqlTime.checkState(!this.isLegacyTimestamp(), "getMillis() can be called in new timestamp semantics only");
        return this.millis;
    }

    @Deprecated
    public long getMillisUtc() {
        SqlTime.checkState(this.isLegacyTimestamp(), "getMillisUtc() can be called in legacy timestamp semantics only");
        return this.millis;
    }

    @Deprecated
    public Optional<TimeZoneKey> getSessionTimeZoneKey() {
        return this.sessionTimeZoneKey;
    }

    public boolean isLegacyTimestamp() {
        return this.sessionTimeZoneKey.isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.millis, this.sessionTimeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTime other = (SqlTime)obj;
        return Objects.equals(this.millis, other.millis) && Objects.equals(this.sessionTimeZoneKey, other.sessionTimeZoneKey);
    }

    @JsonValue
    public String toString() {
        if (this.isLegacyTimestamp()) {
            return Instant.ofEpochMilli(this.millis).atZone(ZoneId.of(this.sessionTimeZoneKey.get().getId())).format(formatter);
        }
        return Instant.ofEpochMilli(this.millis).atZone(ZoneOffset.UTC).format(formatter);
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

