/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.function;

import java.util.List;

public class InvocationConvention {
    private final List<InvocationArgumentConvention> argumentConventionList;
    private final InvocationReturnConvention returnConvention;
    private final boolean supportsSession;
    private final boolean supportsInstanceFactory;

    public InvocationConvention(List<InvocationArgumentConvention> argumentConventionList, InvocationReturnConvention returnConvention, boolean supportsSession, boolean supportsInstanceFactory) {
        this.argumentConventionList = argumentConventionList;
        this.returnConvention = returnConvention;
        this.supportsSession = supportsSession;
        this.supportsInstanceFactory = supportsInstanceFactory;
    }

    public InvocationReturnConvention getReturnConvention() {
        return this.returnConvention;
    }

    public List<InvocationArgumentConvention> getArgumentConventions() {
        return this.argumentConventionList;
    }

    public InvocationArgumentConvention getArgumentConvention(int index) {
        return this.argumentConventionList.get(index);
    }

    public boolean supportsSession() {
        return this.supportsSession;
    }

    public boolean supportsInstanceFactor() {
        return this.supportsInstanceFactory;
    }

    public String toString() {
        return "(" + this.argumentConventionList.toString() + ")" + this.returnConvention;
    }

    public static enum InvocationReturnConvention {
        FAIL_ON_NULL,
        NULLABLE_RETURN;

    }

    public static enum InvocationArgumentConvention {
        NEVER_NULL,
        BOXED_NULLABLE,
        NULL_FLAG,
        BLOCK_POSITION,
        FUNCTION;

    }
}

