/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import java.util.List;

public class TimestampParametricType
implements ParametricType {
    public static final TimestampParametricType TIMESTAMP = new TimestampParametricType();

    @Override
    public String getName() {
        return "timestamp";
    }

    @Override
    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return TimestampType.TIMESTAMP;
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one parameter for TIMESTAMP");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("TIMESTAMP precision must be a number");
        }
        long precision = parameter.getLongLiteral();
        if (precision < 0L || precision > 12L) {
            throw new IllegalArgumentException("Invalid TIMESTAMP precision " + precision);
        }
        return TimestampType.createTimestampType((int)precision);
    }
}

