/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.airlift.slice.XxHash64;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.Int96ArrayBlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TypeOperatorDeclaration;
import io.prestosql.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;

class LongTimestampWithTimeZoneType
extends TimestampWithTimeZoneType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(LongTimestampWithTimeZoneType.class, MethodHandles.lookup(), LongTimestampWithTimeZone.class);

    public LongTimestampWithTimeZoneType(int precision) {
        super(precision, LongTimestampWithTimeZone.class);
        if (precision < 4 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [%s, %s]", 4, 12));
        }
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 12;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int96ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int96ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position));
            blockBuilder.writeInt(LongTimestampWithTimeZoneType.getFraction(block, position));
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Object getObject(Block block, int position) {
        long packedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position);
        int fraction = LongTimestampWithTimeZoneType.getFraction(block, position);
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction(DateTimeEncoding.unpackMillisUtc(packedEpochMillis), fraction, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LongTimestampWithTimeZone timestamp = (LongTimestampWithTimeZone)value;
        blockBuilder.writeLong(DateTimeEncoding.packDateTimeWithZone(timestamp.getEpochMillis(), timestamp.getTimeZoneKey()));
        blockBuilder.writeInt(timestamp.getPicosOfMilli());
        blockBuilder.closeEntry();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long packedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position);
        int fraction = LongTimestampWithTimeZoneType.getFraction(block, position);
        return SqlTimestampWithTimeZone.newInstance(this.getPrecision(), DateTimeEncoding.unpackMillisUtc(packedEpochMillis), fraction, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    private static long getPackedEpochMillis(Block block, int position) {
        return block.getLong(position, 0);
    }

    private static long getEpochMillis(Block block, int position) {
        return DateTimeEncoding.unpackMillisUtc(LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position));
    }

    private static int getFraction(Block block, int position) {
        return block.getInt(position, 8);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.equal(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.equal(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getFraction(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getFraction(rightBlock, rightPosition));
    }

    private static boolean equal(long leftEpochMillis, int leftFraction, long rightEpochMillis, int rightFraction) {
        return leftEpochMillis == rightEpochMillis && leftFraction == rightFraction;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(LongTimestampWithTimeZone value) {
        return LongTimestampWithTimeZoneType.xxHash64(value.getEpochMillis(), value.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return LongTimestampWithTimeZoneType.xxHash64(LongTimestampWithTimeZoneType.getEpochMillis(block, position), LongTimestampWithTimeZoneType.getFraction(block, position));
    }

    private static long xxHash64(long epochMillis, int fraction) {
        return XxHash64.hash((long)epochMillis) ^ XxHash64.hash((long)fraction);
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.comparison(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.comparison(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getFraction(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getFraction(rightBlock, rightPosition));
    }

    private static int comparison(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        int value = Long.compare(leftEpochMillis, rightEpochMillis);
        if (value != 0) {
            return value;
        }
        return Integer.compare(leftPicosOfMilli, rightPicosOfMilli);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.lessThan(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.lessThan(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getFraction(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getFraction(rightBlock, rightPosition));
    }

    private static boolean lessThan(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        return leftEpochMillis < rightEpochMillis || leftEpochMillis == rightEpochMillis && leftPicosOfMilli < rightPicosOfMilli;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.lessThanOrEqual(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.lessThanOrEqual(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getFraction(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getFraction(rightBlock, rightPosition));
    }

    private static boolean lessThanOrEqual(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        return leftEpochMillis < rightEpochMillis || leftEpochMillis == rightEpochMillis && leftPicosOfMilli <= rightPicosOfMilli;
    }
}

