/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.prestosql.spi.type.TimeWithTimeZoneTypes;
import io.prestosql.spi.type.Timestamps;
import java.util.Objects;

public final class SqlTimeWithTimeZone {
    private final int precision;
    private final long picos;
    private final int offsetMinutes;

    public static SqlTimeWithTimeZone newInstance(int precision, long picoseconds, int offsetMinutes) {
        return new SqlTimeWithTimeZone(precision, picoseconds, offsetMinutes);
    }

    private SqlTimeWithTimeZone(int precision, long picos, int offsetMinutes) {
        this.precision = precision;
        this.picos = picos;
        this.offsetMinutes = offsetMinutes;
    }

    public long getPicos() {
        return this.picos;
    }

    public int getOffsetMinutes() {
        return this.offsetMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTimeWithTimeZone other = (SqlTimeWithTimeZone)o;
        return this.precision == other.precision && TimeWithTimeZoneTypes.normalizePicos(this.picos, this.offsetMinutes) == TimeWithTimeZoneTypes.normalizePicos(other.picos, this.offsetMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.precision, TimeWithTimeZoneTypes.normalizePicos(this.picos, this.offsetMinutes));
    }

    @JsonValue
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%02d:%02d:%02d", this.picos / 3600000000000000L, this.picos / 60000000000000L % 60L, this.picos / 1000000000000L % 60L));
        if (this.precision > 0) {
            long scaledFraction = this.picos % 1000000000000L / Timestamps.POWERS_OF_TEN[12 - this.precision];
            builder.append(".");
            builder.append(String.format("%0" + this.precision + "d", scaledFraction));
        }
        builder.append(String.format("%s%02d:%02d", Character.valueOf(this.offsetMinutes >= 0 ? (char)'+' : '-'), Math.abs(this.offsetMinutes / 60), Math.abs(this.offsetMinutes % 60)));
        return builder.toString();
    }
}

