/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.prestosql.spi.block.ArrayBlockBuilder;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.block.PageBuilderStatus;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayBlockBuilder {
    private static final int THREE_INTS_ENTRY_SIZE = 32;
    private static final int EXPECTED_ENTRY_COUNT = 100;

    @Test
    public void testArrayBlockIsFull() {
        this.testIsFull(new PageBuilderStatus(3200));
    }

    private void testIsFull(PageBuilderStatus pageBuilderStatus) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, pageBuilderStatus.createBlockBuilderStatus(), 100);
        Assert.assertTrue((boolean)pageBuilderStatus.isEmpty());
        while (!pageBuilderStatus.isFull()) {
            BlockBuilder elementBuilder = blockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong(elementBuilder, 12L);
            elementBuilder.appendNull();
            BigintType.BIGINT.writeLong(elementBuilder, 34L);
            blockBuilder.closeEntry();
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)100);
        Assert.assertEquals((boolean)pageBuilderStatus.isFull(), (boolean)true);
    }

    @Test
    public void testRetainedSizeInBytes() {
        int expectedEntries = 1000;
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, expectedEntries);
        long initialRetainedSize = arrayBlockBuilder.getRetainedSizeInBytes();
        for (int i = 0; i < expectedEntries; ++i) {
            BlockBuilder arrayElementBuilder = arrayBlockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong(arrayElementBuilder, (long)i);
            arrayBlockBuilder.closeEntry();
        }
        Assert.assertTrue((arrayBlockBuilder.getRetainedSizeInBytes() >= (long)(expectedEntries * 8 + ClassLayout.parseClass(LongArrayBlockBuilder.class).instanceSize()) + initialRetainedSize ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="Expected current entry to be closed but was opened")
    public void testConcurrentWriting() {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100);
        BlockBuilder elementBlockWriter = blockBuilder.beginBlockEntry();
        elementBlockWriter.writeLong(45L).closeEntry();
        blockBuilder.appendStructure(new LongArrayBlockBuilder(null, 1).writeLong(123L).closeEntry().build());
    }
}

