/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.BlockTestUtils;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.TestingBlockEncodingSerde;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryBlockEncoding {
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();

    @Test
    public void testRoundTrip() {
        int positionCount = 40;
        BlockBuilder dictionaryBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 4);
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "alice");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "bob");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "charlie");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "dave");
        Block dictionary = dictionaryBuilder.build();
        int[] ids = new int[positionCount];
        for (int i = 0; i < 40; ++i) {
            ids[i] = i % 4;
        }
        DictionaryBlock dictionaryBlock = new DictionaryBlock(dictionary, ids);
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, (Block)dictionaryBlock);
        Block actualBlock = this.blockEncodingSerde.readBlock((SliceInput)sliceOutput.slice().getInput());
        Assert.assertTrue((boolean)(actualBlock instanceof DictionaryBlock));
        DictionaryBlock actualDictionaryBlock = (DictionaryBlock)actualBlock;
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualDictionaryBlock.getDictionary(), dictionary);
        for (int position = 0; position < actualDictionaryBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)actualDictionaryBlock.getId(position), (int)ids[position]);
        }
        Assert.assertEquals((Object)actualDictionaryBlock.getDictionarySourceId(), (Object)dictionaryBlock.getDictionarySourceId());
    }
}

