/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.block.ArrayBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.IntArrayBlock;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.block.RowBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLazyBlock {
    @Test
    public void testListener() {
        ArrayList notifications = new ArrayList();
        LazyBlock lazyBlock = new LazyBlock(1, () -> TestLazyBlock.createSingleValueBlock(1));
        LazyBlock.listenForLoads((Block)lazyBlock, notifications::add);
        Block loadedBlock = lazyBlock.getBlock();
        Assert.assertEquals(notifications, (Collection)ImmutableList.of((Object)loadedBlock));
        loadedBlock = lazyBlock.getBlock();
        Assert.assertEquals(notifications, (Collection)ImmutableList.of((Object)loadedBlock));
    }

    @Test
    public void testNestedListener() {
        ArrayList<Block> actualNotifications = new ArrayList<Block>();
        LazyBlock lazyBlock = new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveRowBlock);
        LazyBlock.listenForLoads((Block)lazyBlock, actualNotifications::add);
        ArrayList<Block> expectedNotifications = new ArrayList<Block>();
        TestLazyBlock.assertNotificationsRecursive(5, (Block)lazyBlock, actualNotifications, expectedNotifications);
    }

    private static void assertNotificationsRecursive(int depth, Block lazyBlock, List<Block> actualNotifications, List<Block> expectedNotifications) {
        Assert.assertFalse((boolean)lazyBlock.isLoaded());
        Block loadedBlock = ((LazyBlock)lazyBlock).getBlock();
        expectedNotifications.add(loadedBlock);
        Assert.assertEquals(actualNotifications, expectedNotifications);
        if (loadedBlock instanceof ArrayBlock) {
            long expectedSize = 5 * loadedBlock.getPositionCount();
            Assert.assertEquals((long)loadedBlock.getSizeInBytes(), (long)expectedSize);
            Block elementsBlock = (Block)loadedBlock.getChildren().get(0);
            if (depth > 0) {
                TestLazyBlock.assertNotificationsRecursive(depth - 1, elementsBlock, actualNotifications, expectedNotifications);
            }
            Assert.assertEquals((long)loadedBlock.getSizeInBytes(), (long)(expectedSize += elementsBlock.getSizeInBytes()));
            return;
        }
        if (loadedBlock instanceof RowBlock) {
            long expectedSize = 5 * loadedBlock.getPositionCount();
            Assert.assertEquals((long)loadedBlock.getSizeInBytes(), (long)expectedSize);
            for (Block fieldBlock : loadedBlock.getChildren()) {
                if (depth > 0) {
                    TestLazyBlock.assertNotificationsRecursive(depth - 1, fieldBlock, actualNotifications, expectedNotifications);
                }
                long fieldBlockSize = fieldBlock.getSizeInBytes();
                Assert.assertEquals((long)loadedBlock.getSizeInBytes(), (long)(expectedSize += fieldBlockSize));
            }
            return;
        }
        throw new IllegalArgumentException("Unexpected loaded block type: " + loadedBlock.getClass().getSimpleName());
    }

    private static Block createSingleValueBlock(int value) {
        return new IntArrayBlock(1, Optional.empty(), new int[]{value});
    }

    private static Block createInfiniteRecursiveRowBlock() {
        return RowBlock.fromFieldBlocks((int)1, Optional.empty(), (Block[])new Block[]{new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock), new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock), new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock)});
    }

    private static Block createInfiniteRecursiveArrayBlock() {
        return ArrayBlock.fromElementBlock((int)1, Optional.empty(), (int[])new int[]{0, 1}, (Block)new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveRowBlock));
    }
}

