/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.PageBuilderStatus;
import io.prestosql.spi.block.VariableWidthBlockBuilder;
import io.prestosql.spi.type.VarcharType;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableWidthBlockBuilder {
    private static final int BLOCK_BUILDER_INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlockBuilder.class).instanceSize();
    private static final int SLICE_INSTANCE_SIZE = ClassLayout.parseClass(DynamicSliceOutput.class).instanceSize() + ClassLayout.parseClass(Slice.class).instanceSize();
    private static final int VARCHAR_VALUE_SIZE = 7;
    private static final int VARCHAR_ENTRY_SIZE = 11;
    private static final int EXPECTED_ENTRY_COUNT = 3;

    @Test
    public void testFixedBlockIsFull() {
        this.testIsFull(new PageBuilderStatus(33));
    }

    @Test
    public void testNewBlockBuilderLike() {
        int entries = 12345;
        double resetSkew = 1.25;
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, entries, entries);
        for (int i = 0; i < entries; ++i) {
            blockBuilder.writeByte(i);
            blockBuilder.closeEntry();
        }
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        blockBuilder.writeByte(1);
        long actualArrayBytes = SizeOf.sizeOf((int[])new int[(int)Math.ceil(resetSkew * (double)(entries + 1))]) + SizeOf.sizeOf((boolean[])new boolean[(int)Math.ceil(resetSkew * (double)entries)]);
        long actualSliceBytes = (long)SLICE_INSTANCE_SIZE + SizeOf.sizeOf((byte[])new byte[(int)Math.ceil(resetSkew * (double)entries)]);
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)((long)BLOCK_BUILDER_INSTANCE_SIZE + actualSliceBytes + actualArrayBytes));
    }

    private void testIsFull(PageBuilderStatus pageBuilderStatus) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(pageBuilderStatus.createBlockBuilderStatus(), 32, 1024);
        Assert.assertTrue((boolean)pageBuilderStatus.isEmpty());
        while (!pageBuilderStatus.isFull()) {
            VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, Slices.allocate((int)7));
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)3);
        Assert.assertEquals((boolean)pageBuilderStatus.isFull(), (boolean)true);
    }
}

