/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.type.TimeZoneKey;
import java.time.Instant;
import java.util.Locale;
import java.util.Optional;

public final class TestingSession {
    public static final ConnectorSession SESSION = new ConnectorSession(){

        public String getQueryId() {
            return "test_query_id";
        }

        public Optional<String> getSource() {
            return Optional.of("TestSource");
        }

        public ConnectorIdentity getIdentity() {
            return ConnectorIdentity.ofUser((String)"user");
        }

        public TimeZoneKey getTimeZoneKey() {
            return TimeZoneKey.UTC_KEY;
        }

        public Locale getLocale() {
            return Locale.ENGLISH;
        }

        public Instant getStart() {
            return Instant.ofEpochMilli(0L);
        }

        public Optional<String> getTraceToken() {
            return Optional.empty();
        }

        public <T> T getProperty(String name, Class<T> type) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
    };

    private TestingSession() {
    }
}

