/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSortedRangeSet {
    @Benchmark
    public SortedRangeSet benchmarkBuilder(Data data) {
        SortedRangeSet build = new SortedRangeSet.Builder((Type)BigintType.BIGINT).addAll(data.ranges).build();
        return build;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSortedRangeSet.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        public List<Range> ranges;

        @Setup(value=Level.Iteration)
        public void init() {
            this.ranges = new ArrayList<Range>();
            int factor = 0;
            for (int i = 0; i < 10000; ++i) {
                long from = ThreadLocalRandom.current().nextLong(100L) + (long)(factor * 100);
                long to = ThreadLocalRandom.current().nextLong(100L) + (long)((factor + 1) * 100);
                ++factor;
                this.ranges.add(new Range(Marker.above((Type)BigintType.BIGINT, (Object)from), Marker.below((Type)BigintType.BIGINT, (Object)to)));
            }
        }
    }
}

