/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.TestingBlockEncodingSerde;
import io.prestosql.spi.block.TestingBlockJsonSerde;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.HyperLogLogType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.TestingIdType;
import io.prestosql.spi.type.TestingTypeDeserializer;
import io.prestosql.spi.type.TestingTypeManager;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDomain {
    @Test
    public void testOrderableNone() {
        Domain domain = Domain.none((Type)BigintType.BIGINT);
        Assert.assertTrue((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testEquatableNone() {
        Domain domain = Domain.none((Type)TestingIdType.ID);
        Assert.assertTrue((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.all((Type)TestingIdType.ID));
    }

    @Test
    public void testUncomparableNone() {
        Domain domain = Domain.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.all((Type)HyperLogLogType.HYPER_LOG_LOG));
    }

    @Test
    public void testOrderableAll() {
        Domain domain = Domain.all((Type)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none((Type)BigintType.BIGINT));
    }

    @Test
    public void testFloatingPointOrderableAll() {
        Domain domain = Domain.all((Type)RealType.REAL);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)RealType.REAL));
        Assert.assertEquals((Object)domain.getType(), (Object)RealType.REAL);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(-3.4028235E38f)));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(0.0f)));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(Float.MAX_VALUE)));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(Float.MIN_VALUE)));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Float.floatToRawIntBits(Float.NaN)));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)2143294004L));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none((Type)RealType.REAL));
        domain = Domain.all((Type)DoubleType.DOUBLE);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)domain.getType(), (Object)DoubleType.DOUBLE);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)-1.7976931348623157E308));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0.0));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Double.MAX_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Double.MIN_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Double.NaN));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Double.longBitsToDouble(9221140251894092340L)));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none((Type)DoubleType.DOUBLE));
    }

    @Test
    public void testEquatableAll() {
        Domain domain = Domain.all((Type)TestingIdType.ID);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none((Type)TestingIdType.ID));
    }

    @Test
    public void testUncomparableAll() {
        Domain domain = Domain.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertTrue((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.none((Type)HyperLogLogType.HYPER_LOG_LOG));
    }

    @Test
    public void testOrderableNullOnly() {
        Domain domain = Domain.onlyNull((Type)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertTrue((boolean)domain.isOnlyNull());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getNullableSingleValue(), null);
    }

    @Test
    public void testEquatableNullOnly() {
        Domain domain = Domain.onlyNull((Type)TestingIdType.ID);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertTrue((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.notNull((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getNullableSingleValue(), null);
    }

    @Test
    public void testUncomparableNullOnly() {
        Domain domain = Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertTrue((boolean)domain.isOnlyNull());
        Assert.assertTrue((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE));
        Assert.assertTrue((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getNullableSingleValue(), null);
    }

    @Test
    public void testOrderableNotNull() {
        Domain domain = Domain.notNull((Type)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
    }

    @Test
    public void testEquatableNotNull() {
        Domain domain = Domain.notNull((Type)TestingIdType.ID);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.onlyNull((Type)TestingIdType.ID));
    }

    @Test
    public void testUncomparableNotNull() {
        Domain domain = Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertFalse((boolean)domain.isSingleValue());
        Assert.assertFalse((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG));
        Assert.assertEquals((Object)domain.getType(), (Object)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)Slices.EMPTY_SLICE));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG));
    }

    @Test
    public void testOrderableSingleValue() {
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)0L);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertTrue((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)domain.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue((Object)Long.MAX_VALUE));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)true));
        Assert.assertEquals((Object)domain.getSingleValue(), (Object)0L);
        Assert.assertEquals((Object)domain.getNullableSingleValue(), (Object)0L);
        try {
            Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEquatableSingleValue() {
        Domain domain = Domain.singleValue((Type)TestingIdType.ID, (Object)0L);
        Assert.assertFalse((boolean)domain.isNone());
        Assert.assertFalse((boolean)domain.isAll());
        Assert.assertTrue((boolean)domain.isSingleValue());
        Assert.assertTrue((boolean)domain.isNullableSingleValue());
        Assert.assertFalse((boolean)domain.isOnlyNull());
        Assert.assertFalse((boolean)domain.isNullAllowed());
        Assert.assertEquals((Object)domain.getValues(), (Object)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)domain.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertTrue((boolean)domain.includesNullableValue((Object)0L));
        Assert.assertFalse((boolean)domain.includesNullableValue(null));
        Assert.assertEquals((Object)domain.complement(), (Object)Domain.create((ValueSet)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement(), (boolean)true));
        Assert.assertEquals((Object)domain.getSingleValue(), (Object)0L);
        Assert.assertEquals((Object)domain.getNullableSingleValue(), (Object)0L);
        try {
            Domain.create((ValueSet)ValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}), (boolean)false).getSingleValue();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testUncomparableSingleValue() {
        Domain.singleValue((Type)HyperLogLogType.HYPER_LOG_LOG, (Object)Slices.EMPTY_SLICE);
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).overlaps(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.all((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.none((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.notNull((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.onlyNull((Type)BigintType.BIGINT).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).contains(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)));
    }

    @Test
    public void testIntersect() {
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).intersect(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).intersect(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).intersect(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).intersect(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).intersect(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).intersect(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).intersect(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).intersect(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
    }

    @Test
    public void testUnion() {
        this.assertUnion(Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.none((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT));
        this.assertUnion(Domain.all((Type)BigintType.BIGINT), Domain.none((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.notNull((Type)BigintType.BIGINT), Domain.onlyNull((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.all((Type)BigintType.BIGINT), Domain.all((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.notNull((Type)BigintType.BIGINT), Domain.notNull((Type)BigintType.BIGINT));
        this.assertUnion(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L), Domain.onlyNull((Type)BigintType.BIGINT), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)true));
        this.assertUnion(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true));
        this.assertUnion(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false), Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true));
    }

    @Test
    public void testSubtract() {
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.all((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)true));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.none((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.notNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.notNull((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)}), (boolean)false));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.onlyNull((Type)BigintType.BIGINT).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.all((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.none((Type)BigintType.BIGINT)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.notNull((Type)BigintType.BIGINT)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.onlyNull((Type)BigintType.BIGINT)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)0L).subtract(Domain.singleValue((Type)BigintType.BIGINT, (Object)0L)), (Object)Domain.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).subtract(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)true)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true).subtract(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)), (Object)Domain.onlyNull((Type)BigintType.BIGINT));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        Domain domain = Domain.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.none((Type)DoubleType.DOUBLE);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.notNull((Type)BooleanType.BOOLEAN);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.onlyNull((Type)VarcharType.VARCHAR);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)Long.MIN_VALUE);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.singleValue((Type)TestingIdType.ID, (Object)Long.MIN_VALUE);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
        domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)3L, (boolean)true)}), (boolean)true);
        Assert.assertEquals((Object)domain, (Object)mapper.readValue(mapper.writeValueAsString((Object)domain), Domain.class));
    }

    private void assertUnion(Domain first, Domain second, Domain expected) {
        Assert.assertEquals((Object)first.union(second), (Object)expected);
        Assert.assertEquals((Object)Domain.union((List)ImmutableList.of((Object)first, (Object)second)), (Object)expected);
    }
}

