/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.TestingBlockEncodingSerde;
import io.prestosql.spi.block.TestingBlockJsonSerde;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.TestingTypeDeserializer;
import io.prestosql.spi.type.TestingTypeManager;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMarker {
    @Test
    public void testTypes() {
        Assert.assertEquals((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L).getType(), (Object)BigintType.BIGINT);
        Assert.assertEquals((Object)Marker.upperUnbounded((Type)BigintType.BIGINT).getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testUnbounded() {
        Assert.assertTrue((boolean)Marker.lowerUnbounded((Type)BigintType.BIGINT).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.lowerUnbounded((Type)BigintType.BIGINT).isUpperUnbounded());
        Assert.assertTrue((boolean)Marker.upperUnbounded((Type)BigintType.BIGINT).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.upperUnbounded((Type)BigintType.BIGINT).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.below((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
        Assert.assertFalse((boolean)Marker.above((Type)BigintType.BIGINT, (Object)1L).isLowerUnbounded());
        Assert.assertFalse((boolean)Marker.above((Type)BigintType.BIGINT, (Object)1L).isUpperUnbounded());
    }

    @Test
    public void testComparisons() {
        ImmutableList markers = ImmutableList.of((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT), (Object)Marker.above((Type)BigintType.BIGINT, (Object)0L), (Object)Marker.below((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.above((Type)BigintType.BIGINT, (Object)1L), (Object)Marker.below((Type)BigintType.BIGINT, (Object)2L), (Object)Marker.upperUnbounded((Type)BigintType.BIGINT));
        Assert.assertTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)markers));
        for (int i = 0; i < markers.size(); ++i) {
            for (int j = 0; j < markers.size(); ++j) {
                Assert.assertTrue((((Marker)markers.get(i)).compareTo((Marker)markers.get(j)) == Integer.compare(i, j) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testAdjacency() {
        ImmutableMap markers = ImmutableMap.builder().put((Object)Marker.lowerUnbounded((Type)BigintType.BIGINT), (Object)-1000).put((Object)Marker.above((Type)BigintType.BIGINT, (Object)0L), (Object)-100).put((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L), (Object)-1).put((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L), (Object)0).put((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L), (Object)1).put((Object)Marker.below((Type)BigintType.BIGINT, (Object)2L), (Object)100).put((Object)Marker.upperUnbounded((Type)BigintType.BIGINT), (Object)1000).build();
        for (Map.Entry entry1 : markers.entrySet()) {
            for (Map.Entry entry2 : markers.entrySet()) {
                boolean adjacent = ((Marker)entry1.getKey()).isAdjacent((Marker)entry2.getKey());
                boolean distanceIsOne = Math.abs((Integer)entry1.getValue() - (Integer)entry2.getValue()) == 1;
                Assert.assertEquals((boolean)adjacent, (boolean)distanceIsOne);
            }
        }
        Assert.assertEquals((Object)Marker.below((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent(), (Object)Marker.above((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.above((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent(), (Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Marker.exactly((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent(), (Object)Marker.below((Type)BigintType.BIGINT, (Object)1L));
        try {
            Marker.below((Type)BigintType.BIGINT, (Object)1L).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.above((Type)BigintType.BIGINT, (Object)1L).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.lowerUnbounded((Type)BigintType.BIGINT).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.lowerUnbounded((Type)BigintType.BIGINT).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.upperUnbounded((Type)BigintType.BIGINT).lesserAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Marker.upperUnbounded((Type)BigintType.BIGINT).greaterAdjacent();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleNaN() {
        Assertions.assertThatThrownBy(() -> Marker.above((Type)DoubleType.DOUBLE, (Object)Double.NaN)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> Marker.exactly((Type)DoubleType.DOUBLE, (Object)Double.NaN)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> Marker.below((Type)DoubleType.DOUBLE, (Object)Double.NaN)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testRealNaN() {
        Assertions.assertThatThrownBy(() -> Marker.above((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NaN))).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> Marker.exactly((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NaN))).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> Marker.below((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.NaN))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        Marker marker = Marker.above((Type)BigintType.BIGINT, (Object)0L);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.exactly((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"));
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.below((Type)DoubleType.DOUBLE, (Object)0.123);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.exactly((Type)BooleanType.BOOLEAN, (Object)true);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.upperUnbounded((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
        marker = Marker.lowerUnbounded((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)marker, (Object)mapper.readValue(mapper.writeValueAsString((Object)marker), Marker.class));
    }
}

