/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.TestingBlockEncodingSerde;
import io.prestosql.spi.block.TestingBlockJsonSerde;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.TestingTypeDeserializer;
import io.prestosql.spi.type.TestingTypeManager;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSortedRangeSet {
    @Test
    public void testEmptySet() {
        SortedRangeSet rangeSet = SortedRangeSet.none((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertTrue((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)rangeSet.getOrderedRanges()));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)0);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testEntireSet() {
        SortedRangeSet rangeSet = SortedRangeSet.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertTrue((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)1);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testSingleValue() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)10L, (Object[])new Object[0]);
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)10L)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertTrue((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)10L))));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)1);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)10L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)9L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testBoundedSet() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)false), Range.equal((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)false, (Object)5L, (boolean)true)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Object)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)5L, (boolean)true), (Object)Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)false));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)false, (Object)9L, (boolean)false), Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)11L)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)normalizedResult));
        Assert.assertEquals((Object)rangeSet, (Object)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)normalizedResult));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)3);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)7L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)9L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testUnboundedSet() {
        SortedRangeSet rangeSet = SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)10L), (Range[])new Range[]{Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)true, (Object)4L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)4L, (boolean)true, (Object)6L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)false), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)false, (Object)11L, (boolean)false)});
        ImmutableList normalizedResult = ImmutableList.of((Object)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)6L, (boolean)false), (Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)9L));
        SortedRangeSet complement = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)6L, (boolean)true, (Object)9L, (boolean)true)});
        Assert.assertEquals((Object)rangeSet.getType(), (Object)BigintType.BIGINT);
        Assert.assertFalse((boolean)rangeSet.isNone());
        Assert.assertFalse((boolean)rangeSet.isAll());
        Assert.assertFalse((boolean)rangeSet.isSingleValue());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)rangeSet.getOrderedRanges(), (Iterable)normalizedResult));
        Assert.assertEquals((Object)rangeSet, (Object)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)normalizedResult));
        Assert.assertEquals((int)rangeSet.getRangeCount(), (int)3);
        Assert.assertEquals((Object)rangeSet.complement(), (Object)complement);
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.lowerUnbounded((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)4L)));
        Assert.assertFalse((boolean)rangeSet.includesMarker(Marker.exactly((Type)BigintType.BIGINT, (Object)7L)));
        Assert.assertTrue((boolean)rangeSet.includesMarker(Marker.upperUnbounded((Type)BigintType.BIGINT)));
    }

    @Test
    public void testGetSingleValue() {
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).getSingleValue(), (Object)0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SortedRangeSet.all((Type)BigintType.BIGINT).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("SortedRangeSet does not have just a single value");
    }

    @Test
    public void testSpan() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SortedRangeSet.none((Type)BigintType.BIGINT).getSpan()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot get span if no ranges exist");
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).getSpan(), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).getSpan(), (Object)Range.equal((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)1L, (boolean)true));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}).getSpan(), (Object)Range.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).overlaps((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).overlaps((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertTrue((boolean)SortedRangeSet.all((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.none((Type)BigintType.BIGINT).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.lessThan((Type)BigintType.BIGINT, (Object)0L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).contains((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)})));
        Assert.assertTrue((boolean)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
        Assert.assertFalse((boolean)SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).contains((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])));
    }

    @Test
    public void testContainsValue() {
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)BigintType.BIGINT)).containsValue(Long.MIN_VALUE).containsValue(0L).containsValue(42L).containsValue(Long.MAX_VALUE);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)41L, (boolean)true), (Range[])new Range[0])).doesNotContainValue(9L).containsValue(10L).containsValue(11L).containsValue(30L).containsValue(41L).doesNotContainValue(42L);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)41L, (boolean)false), (Range[])new Range[0])).doesNotContainValue(10L).containsValue(11L).containsValue(40L).doesNotContainValue(41L);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)RealType.REAL)).containsValue(Float.floatToRawIntBits(42.0f)).containsValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(10.0f), (boolean)true, (Object)Float.floatToRawIntBits(41.0f), (boolean)true), (Range[])new Range[0])).doesNotContainValue(Float.floatToRawIntBits(9.999999f)).containsValue(Float.floatToRawIntBits(10.0f)).containsValue(Float.floatToRawIntBits(41.0f)).doesNotContainValue(Float.floatToRawIntBits(41.00001f)).doesNotContainValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(10.0f), (boolean)false, (Object)Float.floatToRawIntBits(41.0f), (boolean)false), (Range[])new Range[0])).doesNotContainValue(Float.floatToRawIntBits(10.0f)).containsValue(Float.floatToRawIntBits(10.00001f)).containsValue(Float.floatToRawIntBits(40.99999f)).doesNotContainValue(Float.floatToRawIntBits(41.0f)).doesNotContainValue(Float.floatToRawIntBits(Float.NaN));
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.all((Type)DoubleType.DOUBLE)).containsValue(42.0).containsValue(Double.NaN);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)DoubleType.DOUBLE, (Object)10.0, (boolean)true, (Object)41.0, (boolean)true), (Range[])new Range[0])).doesNotContainValue(9.999999999999998).containsValue(10.0).containsValue(41.0).doesNotContainValue(41.00000000000001).doesNotContainValue(Double.NaN);
        TestSortedRangeSet.assertSortedRangeSet(SortedRangeSet.of((Range)Range.range((Type)DoubleType.DOUBLE, (Object)10.0, (boolean)false, (Object)41.0, (boolean)false), (Range[])new Range[0])).doesNotContainValue(10.0).containsValue(10.00000000000001).containsValue(40.99999999999999).doesNotContainValue(41.0).doesNotContainValue(Double.NaN);
    }

    @Test
    public void testIntersect() {
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)4L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)3L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)false, (Object)4L, (boolean)false)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)-1L), (Range[])new Range[0]).intersect((ValueSet)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)-1L, (boolean)true, (Object)1L, (boolean)true), (Range[])new Range[0]));
    }

    @Test
    public void testUnion() {
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.none((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.none((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)3L)}), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}));
        this.assertUnion(SortedRangeSet.all((Type)BigintType.BIGINT), SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.all((Type)BigintType.BIGINT));
        this.assertUnion(SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)4L, (boolean)false), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)3L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.all((Type)BigintType.BIGINT), (Range[])new Range[0]));
        this.assertUnion(SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).complement());
    }

    @Test
    public void testSubtract() {
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).complement());
        Assert.assertEquals((Object)SortedRangeSet.all((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.none((Type)BigintType.BIGINT).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)}).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.all((Type)BigintType.BIGINT)), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.none((Type)BigintType.BIGINT)), (Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])new Object[0])), (Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.equal((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)1L)})), (Object)SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)false), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}));
        Assert.assertEquals((Object)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]).subtract((ValueSet)SortedRangeSet.of((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0])), (Object)SortedRangeSet.none((Type)BigintType.BIGINT));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        SortedRangeSet set = SortedRangeSet.all((Type)BigintType.BIGINT);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.none((Type)DoubleType.DOUBLE);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"abc"), (Object[])new Object[0]);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
        set = SortedRangeSet.of((Range)Range.equal((Type)BooleanType.BOOLEAN, (Object)true), (Range[])new Range[]{Range.equal((Type)BooleanType.BOOLEAN, (Object)false)});
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), SortedRangeSet.class));
    }

    private void assertUnion(SortedRangeSet first, SortedRangeSet second, SortedRangeSet expected) {
        Assert.assertEquals((Object)first.union((ValueSet)second), (Object)expected);
        Assert.assertEquals((Object)first.union((Collection)ImmutableList.of((Object)first, (Object)second)), (Object)expected);
    }

    private static SortedRangeSetAssert assertSortedRangeSet(SortedRangeSet sortedRangeSet) {
        return (SortedRangeSetAssert)Assertions.assertThat(() -> new SortedRangeSetAssert(sortedRangeSet));
    }

    private static class SortedRangeSetAssert {
        private final SortedRangeSet sortedRangeSet;

        public SortedRangeSetAssert(SortedRangeSet sortedRangeSet) {
            this.sortedRangeSet = Objects.requireNonNull(sortedRangeSet, "sortedRangeSet is null");
        }

        public SortedRangeSetAssert containsValue(Object value) {
            if (!this.sortedRangeSet.containsValue(value)) {
                throw new AssertionError((Object)String.format("Expected %s to contain %s", this.sortedRangeSet, value));
            }
            return this;
        }

        public SortedRangeSetAssert doesNotContainValue(Object value) {
            if (this.sortedRangeSet.containsValue(value)) {
                throw new AssertionError((Object)String.format("Expected %s not to contain %s", this.sortedRangeSet, value));
            }
            return this;
        }
    }
}

