/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestChars {
    @Test
    public void testPadSpaces() {
        String nonBmp = "\ud83d\ude81";
        Verify.verify((nonBmp.codePoints().count() == 1L ? 1 : 0) != 0, (String)"nonBmp must be a single character (code point) string", (Object[])new Object[0]);
        Verify.verify((nonBmp.length() == 2 ? 1 : 0) != 0, (String)"nonBmp must be encoded as surrogate pairs (2 Java characters)", (Object[])new Object[0]);
        this.testPadSpaces("", 0, "");
        this.testPadSpaces("", 1, " ");
        this.testPadSpaces("", 3, "   ");
        this.testPadSpaces("ab", 3, "ab ");
        this.testPadSpaces("abc", 3, "abc");
        this.testPadSpaces(nonBmp, 3, nonBmp + "  ");
        this.testPadSpaces(nonBmp + nonBmp, 3, nonBmp + nonBmp + " ");
        this.testPadSpaces(nonBmp + nonBmp + nonBmp, 3, nonBmp + nonBmp + nonBmp);
        Assertions.assertThatThrownBy(() -> Chars.padSpaces((String)(nonBmp + nonBmp + nonBmp + nonBmp), (CharType)CharType.createCharType((long)3L))).hasMessage("pad length is smaller than text length");
        Assertions.assertThatThrownBy(() -> Chars.padSpaces((Slice)Slices.utf8Slice((String)(nonBmp + nonBmp + nonBmp + nonBmp)), (CharType)CharType.createCharType((long)3L))).hasMessage("pad length is smaller than slice length");
        Assertions.assertThatThrownBy(() -> Chars.padSpaces((Slice)Slices.utf8Slice((String)(nonBmp + nonBmp + nonBmp + nonBmp)), (int)3)).hasMessage("pad length is smaller than slice length");
    }

    private void testPadSpaces(String input, int length, String expected) {
        Assert.assertEquals((String)Chars.padSpaces((String)input, (CharType)CharType.createCharType((long)length)), (String)expected);
        Assert.assertEquals((Object)Chars.padSpaces((Slice)Slices.utf8Slice((String)input), (CharType)CharType.createCharType((long)length)), (Object)Slices.utf8Slice((String)expected));
        Assert.assertEquals((Object)Chars.padSpaces((Slice)Slices.utf8Slice((String)input), (int)length), (Object)Slices.utf8Slice((String)expected));
    }

    @Test
    public void testTruncateToLengthAndTrimSpaces() {
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)1));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a  "), (int)1));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"abc"), (int)1));
        Assert.assertEquals((Object)Slices.utf8Slice((String)""), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)0));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c "), (int)3));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c "), (int)4));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c "), (int)5));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)3));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)4));
        Assert.assertEquals((Object)Slices.utf8Slice((String)"a c"), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"a c"), (int)5));
        Assert.assertEquals((Object)Slices.utf8Slice((String)""), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)"  "), (int)1));
        Assert.assertEquals((Object)Slices.utf8Slice((String)""), (Object)Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)""), (int)1));
    }

    @Test
    public void testByteCountWithoutTrailingSpaces() {
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 0, "");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 4, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 3, "bc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 3, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 2, "bc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 6, "abc de");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 7, "bc def");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 7, "abc def");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 6, "bc def");
        TestChars.assertByteCountWithoutTrailingSpace("abc  def ", 3, 1, "");
        TestChars.assertByteCountWithoutTrailingSpace("abc  def ", 3, 3, "  d");
        TestChars.assertByteCountWithoutTrailingSpace("abc  def ", 3, 4, "  de");
        TestChars.assertByteCountWithoutTrailingSpaceFailure("abc def ", 4, 9);
        TestChars.assertByteCountWithoutTrailingSpaceFailure("abc def ", 12, 1);
        TestChars.assertByteCountWithoutTrailingSpaceFailure("abc def ", -1, 1);
        TestChars.assertByteCountWithoutTrailingSpaceFailure("abc def ", 1, -1);
        TestChars.assertByteCountWithoutTrailingSpace("       ", 0, 4, "");
        TestChars.assertByteCountWithoutTrailingSpace("       ", 0, 0, "");
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, -127}, 0, 2, new byte[]{-127, -127});
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, -127}, 0, 1, new byte[]{-127});
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, -127}, 0, 0, new byte[0]);
    }

    @Test
    public void testByteCountWithoutTrailingSpacesWithCodePointLimit() {
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 1, 0, 1, "");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 3, 4, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 4, 4, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 4, 3, "abc");
        TestChars.assertByteCountWithoutTrailingSpace("abc def ", 0, 5, 4, "abc");
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, 32, -127}, 0, 3, 3, new byte[]{-127, -127});
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, 32, -127}, 0, 2, 3, new byte[]{-127, -127});
        TestChars.assertByteCountWithoutTrailingSpace(new byte[]{-127, -127, 32, -127}, 0, 0, 3, new byte[0]);
    }

    private static void assertByteCountWithoutTrailingSpaceFailure(String string, int offset, int maxLength) {
        try {
            Chars.byteCountWithoutTrailingSpace((Slice)Slices.utf8Slice((String)string), (int)offset, (int)maxLength);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void assertByteCountWithoutTrailingSpace(String actual, int offset, int length, String expected) {
        TestChars.assertByteCountWithoutTrailingSpace(Slices.utf8Slice((String)actual).getBytes(), offset, length, Slices.utf8Slice((String)expected).getBytes());
    }

    private static void assertByteCountWithoutTrailingSpace(byte[] actual, int offset, int length, byte[] expected) {
        Slice slice = Slices.wrappedBuffer((byte[])actual);
        int trimmedLength = Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length);
        byte[] bytes = slice.getBytes(offset, trimmedLength);
        Assert.assertEquals((Object)bytes, (Object)expected);
    }

    private static void assertByteCountWithoutTrailingSpace(String actual, int offset, int length, int codePointCount, String expected) {
        TestChars.assertByteCountWithoutTrailingSpace(Slices.utf8Slice((String)actual).getBytes(), offset, length, codePointCount, Slices.utf8Slice((String)expected).getBytes());
    }

    private static void assertByteCountWithoutTrailingSpace(byte[] actual, int offset, int length, int codePointCount, byte[] expected) {
        Slice slice = Slices.wrappedBuffer((byte[])actual);
        int truncatedLength = Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)codePointCount);
        byte[] bytes = slice.getBytes(offset, truncatedLength);
        Assert.assertEquals((Object)bytes, (Object)expected);
    }
}

