/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.VariableWidthBlockBuilder;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.LongDecimalType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongDecimalType {
    private static final LongDecimalType TYPE = (LongDecimalType)LongDecimalType.createDecimalType((int)20, (int)10);
    private static final MethodHandle TYPE_COMPARISON = new TypeOperators().getComparisonOperator((Type)TYPE, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));

    @Test
    public void testCompareTo() {
        this.testCompare("0", "-1234567891.1234567890", 1);
        this.testCompare("1234567890.1234567890", "1234567890.1234567890", 0);
        this.testCompare("1234567890.1234567890", "1234567890.1234567891", -1);
        this.testCompare("1234567890.1234567890", "1234567890.1234567889", 1);
        this.testCompare("1234567890.1234567890", "1234567891.1234567890", -1);
        this.testCompare("1234567890.1234567890", "1234567889.1234567890", 1);
        this.testCompare("0", "1234567891.1234567890", -1);
        this.testCompare("1234567890.1234567890", "0", 1);
        this.testCompare("0", "0", 0);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567890", 0);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567891", 1);
        this.testCompare("-1234567890.1234567890", "-1234567890.1234567889", -1);
        this.testCompare("-1234567890.1234567890", "-1234567891.1234567890", 1);
        this.testCompare("-1234567890.1234567890", "-1234567889.1234567890", -1);
        this.testCompare("0", "-1234567891.1234567890", 1);
        this.testCompare("-1234567890.1234567890", "0", -1);
        this.testCompare("-1234567890.1234567890", "1234567890.1234567890", -1);
        this.testCompare("1234567890.1234567890", "-1234567890.1234567890", 1);
    }

    private void testCompare(String decimalA, String decimalB, int expected) {
        try {
            long actual = TYPE_COMPARISON.invokeExact(this.decimalAsBlock(decimalA), 0, this.decimalAsBlock(decimalB), 0);
            Assert.assertEquals((int)((int)Math.signum(actual)), (int)((int)Math.signum(expected)), (String)("bad comparison result for " + decimalA + ", " + decimalB));
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private Block decimalAsBlock(String value) {
        Slice slice = Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, 1, slice.length());
        TYPE.writeSlice((BlockBuilder)blockBuilder, slice);
        return blockBuilder.build();
    }
}

