/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.HyperLogLogType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TestingIdType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeNotFoundException;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.List;

public class TestingTypeManager
implements TypeManager {
    private static final List<Type> TYPES = ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR, (Object)VarbinaryType.VARBINARY, (Object)TimestampType.TIMESTAMP_MILLIS, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)DateType.DATE, (Object)((Object)TestingIdType.ID), (Object)HyperLogLogType.HYPER_LOG_LOG);
    private final TypeOperators typeOperators = new TypeOperators();

    public Type getType(TypeSignature signature) {
        for (Type type : TYPES) {
            if (!signature.getBase().equals(type.getTypeSignature().getBase())) continue;
            return type;
        }
        throw new TypeNotFoundException(signature);
    }

    public Type fromSqlType(String type) {
        throw new UnsupportedOperationException();
    }

    public Type getType(TypeId id) {
        for (Type type : TYPES) {
            if (!type.getTypeId().equals((Object)id)) continue;
            return type;
        }
        throw new IllegalArgumentException("Type not found: " + id);
    }

    public TypeOperators getTypeOperators() {
        return this.typeOperators;
    }
}

