/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.ByteArrayBlock;
import io.prestosql.spi.block.ByteArrayBlockBuilder;
import io.prestosql.spi.block.EncoderUtil;

public class ByteArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "BYTE_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            sliceOutput.writeBytes(this.getValuesSlice(block));
        } else {
            byte[] valuesWithoutNull = new byte[positionCount];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = block.getByte(i, 0);
                if (block.isNull(i)) continue;
                ++nonNullPositionCount;
            }
            sliceOutput.writeInt(nonNullPositionCount);
            sliceOutput.writeBytes(Slices.wrappedBuffer((byte[])valuesWithoutNull, (int)0, (int)nonNullPositionCount));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int i;
        int positionCount = sliceInput.readInt();
        byte[] valueIsNullPacked = EncoderUtil.retrieveNullBits(sliceInput, positionCount);
        byte[] values = new byte[positionCount];
        if (valueIsNullPacked == null) {
            sliceInput.readBytes(Slices.wrappedBuffer((byte[])values));
            return new ByteArrayBlock(0, positionCount, null, values);
        }
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(valueIsNullPacked, positionCount);
        int nonNullPositionCount = sliceInput.readInt();
        sliceInput.readBytes(Slices.wrappedBuffer((byte[])values, (int)0, (int)nonNullPositionCount));
        int position = nonNullPositionCount - 1;
        for (i = positionCount - 1; i >= (positionCount & 0xFFFFFFF8) && position >= 0; --i) {
            values[i] = values[position];
            if (valueIsNull[i]) continue;
            --position;
        }
        for (i = (positionCount & 0xFFFFFFF8) - 8; i >= 0 && position >= 0; i -= 8) {
            byte packed = valueIsNullPacked[i >>> 3];
            if (packed == 0) {
                System.arraycopy(values, position - 7, values, i, 8);
                position -= 8;
                continue;
            }
            if (packed == -1) continue;
            for (int j = i + 7; j >= i && position >= 0; --j) {
                values[j] = values[position];
                if (valueIsNull[j]) continue;
                --position;
            }
        }
        return new ByteArrayBlock(0, positionCount, valueIsNull, values);
    }

    private Slice getValuesSlice(Block block) {
        if (block instanceof ByteArrayBlock) {
            return ((ByteArrayBlock)block).getValuesSlice();
        }
        if (block instanceof ByteArrayBlockBuilder) {
            return ((ByteArrayBlockBuilder)block).getValuesSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }
}

