/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.spi.block.Block;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import javax.annotation.Nullable;

final class EncoderUtil {
    private EncoderUtil() {
    }

    public static void encodeNullsAsBits(SliceOutput sliceOutput, Block block) {
        boolean mayHaveNull = block.mayHaveNull();
        sliceOutput.writeBoolean(mayHaveNull);
        if (!mayHaveNull) {
            return;
        }
        int positionCount = block.getPositionCount();
        byte[] packedIsNull = new byte[((positionCount & 0xFFFFFFF8) + 1) / 8];
        int currentByte = 0;
        int position = 0;
        while (position < (positionCount & 0xFFFFFFF8)) {
            int value = 0;
            value = (byte)(value | (block.isNull(position) ? 128 : 0));
            value = (byte)(value | (block.isNull(position + 1) ? 64 : 0));
            value = (byte)(value | (block.isNull(position + 2) ? 32 : 0));
            value = (byte)(value | (block.isNull(position + 3) ? 16 : 0));
            value = (byte)(value | (block.isNull(position + 4) ? 8 : 0));
            value = (byte)(value | (block.isNull(position + 5) ? 4 : 0));
            value = (byte)(value | (block.isNull(position + 6) ? 2 : 0));
            packedIsNull[currentByte] = value = (int)((byte)(value | (block.isNull(position + 7) ? 1 : 0)));
            position += 8;
            ++currentByte;
        }
        sliceOutput.writeBytes(packedIsNull);
        if ((positionCount & 7) > 0) {
            int value = 0;
            int mask = 128;
            for (int position2 = positionCount & 0xFFFFFFF8; position2 < positionCount; ++position2) {
                value = (byte)(value | (block.isNull(position2) ? mask : 0));
                mask >>>= 1;
            }
            sliceOutput.appendByte(value);
        }
    }

    public static Optional<boolean[]> decodeNullBits(SliceInput sliceInput, int positionCount) {
        return Optional.ofNullable(EncoderUtil.retrieveNullBits(sliceInput, positionCount)).map(packedIsNull -> EncoderUtil.decodeNullBits(packedIsNull, positionCount));
    }

    public static boolean[] decodeNullBits(byte[] packedIsNull, int positionCount) {
        boolean[] valueIsNull = new boolean[positionCount];
        int currentByte = 0;
        int position = 0;
        while (position < (positionCount & 0xFFFFFFF8)) {
            byte value = packedIsNull[currentByte];
            valueIsNull[position] = (value & 0x80) != 0;
            valueIsNull[position + 1] = (value & 0x40) != 0;
            valueIsNull[position + 2] = (value & 0x20) != 0;
            valueIsNull[position + 3] = (value & 0x10) != 0;
            valueIsNull[position + 4] = (value & 8) != 0;
            valueIsNull[position + 5] = (value & 4) != 0;
            valueIsNull[position + 6] = (value & 2) != 0;
            valueIsNull[position + 7] = (value & 1) != 0;
            position += 8;
            ++currentByte;
        }
        if ((positionCount & 7) > 0) {
            byte value = packedIsNull[packedIsNull.length - 1];
            int mask = 128;
            for (int position2 = positionCount & 0xFFFFFFF8; position2 < positionCount; ++position2) {
                valueIsNull[position2] = (value & mask) != 0;
                mask >>>= 1;
            }
        }
        return valueIsNull;
    }

    @Nullable
    public static byte[] retrieveNullBits(SliceInput sliceInput, int positionCount) {
        if (!sliceInput.readBoolean()) {
            return null;
        }
        try {
            return sliceInput.readNBytes((positionCount + 7) / 8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

