/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.EncoderUtil;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.LongArrayBlockBuilder;

public class LongArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "LONG_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            sliceOutput.writeBytes(this.getValuesSlice(block));
        } else {
            long[] valuesWithoutNull = new long[positionCount];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = block.getLong(i, 0);
                if (block.isNull(i)) continue;
                ++nonNullPositionCount;
            }
            sliceOutput.writeInt(nonNullPositionCount);
            sliceOutput.writeBytes(Slices.wrappedLongArray((long[])valuesWithoutNull, (int)0, (int)nonNullPositionCount));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int i;
        int positionCount = sliceInput.readInt();
        byte[] valueIsNullPacked = EncoderUtil.retrieveNullBits(sliceInput, positionCount);
        long[] values = new long[positionCount];
        if (valueIsNullPacked == null) {
            sliceInput.readBytes(Slices.wrappedLongArray((long[])values));
            return new LongArrayBlock(0, positionCount, null, values);
        }
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(valueIsNullPacked, positionCount);
        int nonNullPositionCount = sliceInput.readInt();
        sliceInput.readBytes(Slices.wrappedLongArray((long[])values, (int)0, (int)nonNullPositionCount));
        int position = nonNullPositionCount - 1;
        for (i = positionCount - 1; i >= (positionCount & 0xFFFFFFF8) && position >= 0; --i) {
            values[i] = values[position];
            if (valueIsNull[i]) continue;
            --position;
        }
        for (i = (positionCount & 0xFFFFFFF8) - 8; i >= 0 && position >= 0; i -= 8) {
            byte packed = valueIsNullPacked[i >>> 3];
            if (packed == 0) {
                System.arraycopy(values, position - 7, values, i, 8);
                position -= 8;
                continue;
            }
            if (packed == -1) continue;
            for (int j = i + 7; j >= i && position >= 0; --j) {
                values[j] = values[position];
                if (valueIsNull[j]) continue;
                --position;
            }
        }
        return new LongArrayBlock(0, positionCount, valueIsNull, values);
    }

    private Slice getValuesSlice(Block block) {
        if (block instanceof LongArrayBlock) {
            return ((LongArrayBlock)block).getValuesSlice();
        }
        if (block instanceof LongArrayBlockBuilder) {
            return ((LongArrayBlockBuilder)block).getValuesSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }
}

