/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.predicate.Primitives;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.TypeUtils;
import javax.annotation.Nullable;

public final class Utils {
    static final TypeOperators TUPLE_DOMAIN_TYPE_OPERATORS = new TypeOperators();

    private Utils() {
    }

    public static Block nativeValueToBlock(Type type, @Nullable Object object) {
        Class<?> expectedClass;
        if (object != null && !(expectedClass = Primitives.wrap(type.getJavaType())).isInstance(object)) {
            throw new IllegalArgumentException(String.format("Object '%s' (%s) is not instance of %s", object, object.getClass().getName(), expectedClass.getName()));
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue(type, blockBuilder, object);
        return blockBuilder.build();
    }

    static Object blockToNativeValue(Type type, Block block) {
        if (block.getPositionCount() != 1) {
            throw new IllegalArgumentException("Block should have exactly one position, but has: " + block.getPositionCount());
        }
        return TypeUtils.readNativeValue(type, block, 0);
    }

    static RuntimeException handleThrowable(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }
}

