/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManager;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.AbstractTestQueries;
import io.prestosql.testing.DistributedQueryRunner;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.ResultWithQueryId;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.assertions.Assert;
import io.prestosql.testing.sql.TestTable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestDistributedQueries
extends AbstractTestQueries {
    protected boolean supportsViews() {
        return true;
    }

    protected boolean supportsArrays() {
        return true;
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Test
    public void testSetSession() {
        MaterializedResult result = this.computeActual("SET SESSION test_string = 'bar'");
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"test_string", (Object)"bar"));
        result = this.computeActual(String.format("SET SESSION %s.connector_long = 999", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_long", (Object)"999"));
        result = this.computeActual(String.format("SET SESSION %s.connector_string = 'baz'", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_string", (Object)"baz"));
        result = this.computeActual(String.format("SET SESSION %s.connector_string = 'ban' || 'ana'", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_string", (Object)"banana"));
        result = this.computeActual(String.format("SET SESSION %s.connector_long = 444", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_long", (Object)"444"));
        result = this.computeActual(String.format("SET SESSION %s.connector_long = 111 + 111", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_long", (Object)"222"));
        result = this.computeActual(String.format("SET SESSION %s.connector_boolean = 111 < 3", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_boolean", (Object)"false"));
        result = this.computeActual(String.format("SET SESSION %s.connector_double = 11.1", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Map)result.getSetSessionProperties(), (Map)ImmutableMap.of((Object)"testing_catalog.connector_double", (Object)"11.1"));
    }

    @Test
    public void testResetSession() {
        MaterializedResult result = this.computeActual(this.getSession(), "RESET SESSION test_string");
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Set)result.getResetSessionProperties(), (Set)ImmutableSet.of((Object)"test_string"));
        result = this.computeActual(this.getSession(), String.format("RESET SESSION %s.connector_string", "testing_catalog"));
        org.testng.Assert.assertTrue((boolean)((Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result)).getField(0)));
        Assert.assertEquals((Set)result.getResetSessionProperties(), (Set)ImmutableSet.of((Object)"testing_catalog.connector_string"));
    }

    @Test
    public void testCreateTable() {
        String tableName = "test_create_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQueryFails("CREATE TABLE " + tableName + " (a bad_type)", ".* Unknown type 'bad_type' for column 'a'");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        tableName = "test_create_table_if_not_exists_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b varchar, c double)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " (d bigint, e varchar)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        tableName = "test_create_original_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        String tableNameLike = "test_create_like_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableNameLike + " (LIKE " + tableName + ", d boolean, e varchar)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike));
        this.assertTableColumnNames(tableNameLike, "a", "b", "c", "d", "e");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("DROP TABLE " + tableNameLike);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike));
    }

    @Test
    public void testCreateTableAsSelect() {
        String tableName = "test_ctas" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertTableColumnNames(tableName, "name", "regionkey");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE IF NOT EXISTS nation AS SELECT orderkey, discount FROM lineitem", 0L);
        this.assertTableColumnNames("nation", "nationkey", "name", "regionkey", "comment");
        this.assertCreateTableAsSelect("SELECT orderdate, orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect("SELECT orderstatus, sum(totalprice) x FROM orders GROUP BY orderstatus", "SELECT count(DISTINCT orderstatus) FROM orders");
        this.assertCreateTableAsSelect("SELECT count(*) x FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey", "SELECT 1");
        this.assertCreateTableAsSelect("SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10", "SELECT 10");
        this.assertCreateTableAsSelect("SELECT '\u2603' unicode", "SELECT 1");
        this.assertCreateTableAsSelect("SELECT * FROM orders WITH DATA", "SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect("SELECT * FROM orders WITH NO DATA", "SELECT * FROM orders LIMIT 0", "SELECT 0");
        this.assertCreateTableAsSelect("SELECT orderdate, orderkey, totalprice FROM orders WHERE orderkey % 2 = 0 UNION ALL SELECT orderdate, orderkey, totalprice FROM orders WHERE orderkey % 2 = 1", "SELECT orderdate, orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "true").build(), "SELECT CAST(orderdate AS DATE) orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT count(*) + 1 FROM orders");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "false").build(), "SELECT CAST(orderdate AS DATE) orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT orderdate, orderkey, totalprice FROM orders UNION ALL SELECT DATE '2000-01-01', 1234567890, 1.23", "SELECT count(*) + 1 FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT orderstatus FROM orders");
        this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    protected void assertExplainAnalyze(@Language(value="SQL") String query) {
        String value = (String)this.computeActual(query).getOnlyValue();
        org.testng.Assert.assertTrue((boolean)value.matches("(?s:.*)CPU:.*, Input:.*, Output(?s:.*)"), (String)String.format("Expected output to contain \"CPU:.*, Input:.*, Output\", but it is %s", value));
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, query, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, expectedQuery, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(Session session, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        String table = "test_table_" + TestTable.randomTableSuffix();
        this.assertUpdate(session, "CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery(session, "SELECT * FROM " + table, expectedQuery);
        this.assertUpdate(session, "DROP TABLE " + table);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, table));
    }

    @Test
    public void testRenameTable() {
        String tableName = "test_rename_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String renamedTable = "test_rename_new_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + renamedTable);
        this.assertQuery("SELECT x FROM " + renamedTable, "VALUES 123");
        String uppercaseName = "TEST_RENAME_" + TestTable.randomTableSuffix();
        this.assertUpdate("ALTER TABLE " + renamedTable + " RENAME TO " + uppercaseName);
        this.assertQuery("SELECT x FROM " + uppercaseName.toLowerCase(Locale.ENGLISH), "VALUES 123");
        this.assertUpdate("DROP TABLE " + uppercaseName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
    }

    @Test
    public void testCommentTable() {
        String tableName = "test_comment_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(id integer)");
        this.assertUpdate("COMMENT ON TABLE " + tableName + " IS 'new comment'");
        MaterializedResult materializedRows = this.computeActual("SHOW CREATE TABLE " + tableName);
        org.testng.Assert.assertTrue((boolean)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(0).toString().contains("COMMENT 'new comment'"));
        this.assertUpdate("COMMENT ON TABLE " + tableName + " IS ''");
        materializedRows = this.computeActual("SHOW CREATE TABLE " + tableName);
        org.testng.Assert.assertTrue((boolean)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(0).toString().contains("COMMENT ''"));
        this.assertUpdate("COMMENT ON TABLE " + tableName + " IS NULL");
        materializedRows = this.computeActual("SHOW CREATE TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(0).toString().contains("COMMENT"));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRenameColumn() {
        String tableName = "test_rename_column_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'some value' x", 1L);
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO y");
        this.assertQuery("SELECT y FROM " + tableName, "VALUES 'some value'");
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN y TO Z");
        this.assertQuery("SELECT z FROM " + tableName, "VALUES 'some value'");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 'some value'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDropColumn() {
        String tableName = "test_drop_column_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x, 111 a", 1L);
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN x");
        this.assertQueryFails("SELECT x FROM " + tableName, ".* Column 'x' cannot be resolved");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN a", ".* Cannot drop the only column in a table");
    }

    @Test
    public void testAddColumn() {
        String tableName = "test_add_column_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT CAST('first' AS varchar) x", 1L);
        this.assertQueryFails("ALTER TABLE " + tableName + " ADD COLUMN x bigint", ".* Column 'x' already exists");
        this.assertQueryFails("ALTER TABLE " + tableName + " ADD COLUMN X bigint", ".* Column 'X' already exists");
        this.assertQueryFails("ALTER TABLE " + tableName + " ADD COLUMN q bad_type", ".* Unknown type 'bad_type' for column 'q'");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN a varchar");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT 'second', 'xxx'", 1L);
        this.assertQuery("SELECT x, a FROM " + tableName, "VALUES ('first', NULL), ('second', 'xxx')");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN b double");
        this.assertUpdate("INSERT INTO " + tableName + " SELECT 'third', 'yyy', 33.3E0", 1L);
        this.assertQuery("SELECT x, a, b FROM " + tableName, "VALUES ('first', NULL, NULL), ('second', 'xxx', NULL), ('third', 'yyy', 33.3)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsert() {
        String query = "SELECT orderdate, orderkey, totalprice FROM orders";
        String tableName = "test_insert_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS " + query + " WITH NO DATA", 0L);
        this.assertQuery("SELECT count(*) FROM " + tableName + "", "SELECT 0");
        this.assertUpdate("INSERT INTO " + tableName + " " + query, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT * FROM " + tableName + "", query);
        this.assertUpdate("INSERT INTO " + tableName + " (orderkey) VALUES (-1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (orderkey) VALUES (null)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (orderdate) VALUES (DATE '2001-01-01')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (orderkey, orderdate) VALUES (-2, DATE '2001-01-02')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (orderdate, orderkey) VALUES (DATE '2001-01-03', -3)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (totalprice) VALUES (1234)", 1L);
        this.assertQuery("SELECT * FROM " + tableName + "", query + " UNION ALL SELECT null, -1, null UNION ALL SELECT null, null, null UNION ALL SELECT DATE '2001-01-01', null, null UNION ALL SELECT DATE '2001-01-02', -2, null UNION ALL SELECT DATE '2001-01-03', -3, null UNION ALL SELECT null, null, 1234");
        this.assertUpdate("INSERT INTO " + tableName + " (orderkey, orderdate, totalprice) SELECT orderkey, orderdate, totalprice FROM orders UNION ALL SELECT orderkey, orderdate, totalprice FROM orders", "SELECT 2 * count(*) FROM orders");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsertWithCoercion() {
        String tableName = "test_insert_with_coercion_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (tinyint_column TINYINT, integer_column INTEGER, decimal_column DECIMAL(5, 3), real_column REAL, char_column CHAR(3), bounded_varchar_column VARCHAR(3), unbounded_varchar_column VARCHAR, date_column DATE)");
        this.assertUpdate("INSERT INTO " + tableName + " (tinyint_column, integer_column, decimal_column, real_column) VALUES (1e0, 2e0, 3e0, 4e0)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (char_column, bounded_varchar_column, unbounded_varchar_column) VALUES (CAST('aa     ' AS varchar), CAST('aa     ' AS varchar), CAST('aa     ' AS varchar))", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (char_column, bounded_varchar_column, unbounded_varchar_column) VALUES (NULL, NULL, NULL)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (char_column, bounded_varchar_column, unbounded_varchar_column) VALUES (CAST(NULL AS varchar), CAST(NULL AS varchar), CAST(NULL AS varchar))", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (date_column) VALUES (TIMESTAMP '2019-11-18 22:13:40')", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 2, 3, 4, NULL, NULL, NULL, NULL), (NULL, NULL, NULL, NULL, 'aa ', 'aa ', 'aa     ', NULL), (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), (NULL, NULL, NULL, NULL, NULL, NULL, NULL, DATE '2019-11-18')");
        this.assertQueryFails("INSERT INTO " + tableName + " (integer_column) VALUES (3e9)", "Out of range for integer: 3.0E9");
        this.assertQueryFails("INSERT INTO " + tableName + " (char_column) VALUES ('abcd')", "Cannot truncate non-space characters on INSERT");
        this.assertQueryFails("INSERT INTO " + tableName + " (bounded_varchar_column) VALUES ('abcd')", "Cannot truncate non-space characters on INSERT");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsertUnicode() {
        String tableName = "test_insert_unicode_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(test varchar)");
        this.assertUpdate("INSERT INTO " + tableName + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' ", 2L);
        Assertions.assertThat((Iterable)this.computeActual("SELECT test FROM " + tableName).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"});
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + "(test varchar)");
        this.assertUpdate("INSERT INTO " + tableName + "(test) VALUES 'aa', 'b\u00e9'", 2L);
        this.assertQuery("SELECT test FROM " + tableName, "VALUES 'aa', 'b\u00e9'");
        this.assertQuery("SELECT test FROM " + tableName + " WHERE test = 'aa'", "VALUES 'aa'");
        this.assertQuery("SELECT test FROM " + tableName + " WHERE test > 'ba'", "VALUES 'b\u00e9'");
        this.assertQuery("SELECT test FROM " + tableName + " WHERE test < 'ba'", "VALUES 'aa'");
        this.assertQueryReturnsEmptyResult("SELECT test FROM " + tableName + " WHERE test = 'ba'");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + "(test varchar)");
        this.assertUpdate("INSERT INTO " + tableName + "(test) VALUES 'a', '\u00e9'", 2L);
        this.assertQuery("SELECT test FROM " + tableName, "VALUES 'a', '\u00e9'");
        this.assertQuery("SELECT test FROM " + tableName + " WHERE test = 'a'", "VALUES 'a'");
        this.assertQuery("SELECT test FROM " + tableName + " WHERE test > 'b'", "VALUES '\u00e9'");
        this.assertQuery("SELECT test FROM " + tableName + " WHERE test < 'b'", "VALUES 'a'");
        this.assertQueryReturnsEmptyResult("SELECT test FROM " + tableName + " WHERE test = 'b'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsertArray() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsArrays());
        String tableName = "test_insert_array_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a ARRAY<DOUBLE>, b ARRAY<BIGINT>)");
        this.assertUpdate("INSERT INTO " + tableName + " (a) VALUES (ARRAY[null])", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (a, b) VALUES (ARRAY[1.23E1], ARRAY[1.23E1])", 1L);
        this.assertQuery("SELECT a[1], b[1] FROM " + tableName, "VALUES (null, null), (12.3, 12)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDelete() {
        String tableName = "test_delete_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderkey % 2 = 0", "SELECT count(*) FROM orders WHERE orderkey % 2 = 0");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders WHERE orderkey % 2 <> 0");
        this.assertUpdate("DELETE FROM " + tableName, "SELECT count(*) FROM orders WHERE orderkey % 2 <> 0");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders LIMIT 0");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE custkey <= 100", "SELECT count(*) FROM orders WHERE custkey <= 100");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders WHERE custkey > 100");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE custkey <= 300", "SELECT count(*) FROM orders WHERE custkey > 100 AND custkey <= 300");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders WHERE custkey > 300");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE custkey <= 500", "SELECT count(*) FROM orders WHERE custkey > 300 AND custkey <= 500");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders WHERE custkey > 500");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderstatus = 'O'", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders WHERE orderstatus <> 'O'");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE rand() < 0", 0L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderkey < 0", 0L);
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderkey > 5 AND orderkey < 4", 0L);
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM lineitem", "SELECT count(*) FROM lineitem");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')", "SELECT count(*) FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus <> 'F')");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM lineitem", "SELECT count(*) FROM lineitem");
        this.assertUpdate("DELETE FROM " + tableName + "\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')\n  AND orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 = 0)\n", "SELECT count(*) FROM lineitem\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus = 'F')\n  AND orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 = 0)");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM lineitem\nWHERE orderkey IN (SELECT orderkey FROM orders WHERE orderstatus <> 'F')\n  OR orderkey IN (SELECT orderkey FROM orders WHERE custkey % 5 <> 0)");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + "\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n", "SELECT count(*) FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NOT NULL\n");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderkey = (SELECT orderkey FROM orders ORDER BY orderkey LIMIT 1)", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderkey = (SELECT orderkey FROM orders WHERE false)", 0L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE EXISTS(SELECT 1 WHERE false)", 0L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE EXISTS(SELECT 1)", "SELECT count(*) - 1 FROM orders");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT CAST(orderstatus AS VARCHAR(15)) orderstatus FROM orders");
        this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE INSERT INTO " + tableName + " SELECT clerk FROM orders");
        this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders UNION ALL SELECT clerk FROM orders");
        this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE TRUE");
        this.assertQuery("SELECT COUNT(*) from " + tableName, "SELECT 0");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", "SELECT count(*) FROM orders");
        this.assertAccessDenied("DELETE FROM " + tableName + " where orderkey < 12", "Cannot select from columns \\[orderkey\\] in table or view .*." + tableName + ".*", TestingAccessControlManager.privilege((String)"orderkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("DELETE FROM " + tableName + " where orderkey < 12", TestingAccessControlManager.privilege((String)"orderdate", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessAllowed("DELETE FROM " + tableName, TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
    }

    @Test
    public void testDropTableIfExists() {
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
        this.assertUpdate("DROP TABLE IF EXISTS test_drop_if_exists");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
    }

    @Test
    public void testView() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String query = "SELECT orderkey, orderstatus, totalprice / 2 half FROM orders";
        String testView = "test_view_" + TestTable.randomTableSuffix();
        String testViewWithComment = "test_view_with_comment_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE VIEW " + testView + " AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW " + testView + " AS " + query);
        this.assertUpdate("CREATE VIEW " + testViewWithComment + " COMMENT 'orders' AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW " + testViewWithComment + " COMMENT 'orders' AS " + query);
        MaterializedResult materializedRows = this.computeActual("SHOW CREATE VIEW " + testViewWithComment);
        org.testng.Assert.assertTrue((boolean)((MaterializedRow)materializedRows.getMaterializedRows().get(0)).getField(0).toString().contains("COMMENT 'orders'"));
        this.assertQuery("SELECT * FROM " + testView, query);
        this.assertQuery("SELECT * FROM " + testViewWithComment, query);
        this.assertQuery("SELECT * FROM " + testView + " a JOIN " + testView + " b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM " + testView, query);
        String name = String.format("%s.%s." + testView, this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertUpdate("DROP VIEW " + testView);
        this.assertUpdate("DROP VIEW " + testViewWithComment);
    }

    @Test
    public void testViewCaseSensitivity() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String upperCaseView = "test_view_uppercase_" + TestTable.randomTableSuffix();
        String mixedCaseView = "test_view_mixedcase_" + TestTable.randomTableSuffix();
        this.computeActual("CREATE VIEW " + upperCaseView + " AS SELECT X FROM (SELECT 123 X)");
        this.computeActual("CREATE VIEW " + mixedCaseView + " AS SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertQuery("SELECT * FROM " + upperCaseView, "SELECT X FROM (SELECT 123 X)");
        this.assertQuery("SELECT * FROM " + mixedCaseView, "SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertUpdate("DROP VIEW " + upperCaseView);
        this.assertUpdate("DROP VIEW " + mixedCaseView);
    }

    @Test
    public void testCompatibleTypeChangeForView() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String tableName = "test_table_" + TestTable.randomTableSuffix();
        String viewName = "test_view_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abcdefg' a", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT a FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abcdefg'");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abc' a", 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abc'");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCompatibleTypeChangeForView2() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String tableName = "test_table_" + TestTable.randomTableSuffix();
        String viewName = "test_view_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT BIGINT '1' v", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT INTEGER '1' v", 1L);
        this.assertQuery("SELECT * FROM " + viewName + " WHERE v = 1", "VALUES 1");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testViewMetadata() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        String viewName = "meta_test_view_" + TestTable.randomTableSuffix();
        String query = "SELECT BIGINT '123' x, 'foo' y";
        this.assertUpdate("CREATE VIEW " + viewName + " AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{"lineitem", "BASE TABLE"}).row(new Object[]{viewName, "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"part", "BASE TABLE"}).row(new Object[]{"partsupp", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).row(new Object[]{"supplier", "BASE TABLE"}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{viewName, this.formatSqlText(query)}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW COLUMNS FROM " + viewName);
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", "", ""}).row(new Object[]{"y", "varchar(3)", "", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
        String expectedSql = this.formatSqlText(String.format("CREATE VIEW %s.%s.%s AS %s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName, query)).trim();
        actual = this.computeActual("SHOW CREATE VIEW " + viewName);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        actual = this.computeActual(String.format("SHOW CREATE VIEW %s.%s." + viewName, this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testShowCreateView() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        Preconditions.checkState((boolean)this.getSession().getCatalog().isPresent(), (Object)"catalog is not set");
        Preconditions.checkState((boolean)this.getSession().getSchema().isPresent(), (Object)"schema is not set");
        String viewName = "test_show_create_view" + TestTable.randomTableSuffix();
        this.assertUpdate("DROP VIEW IF EXISTS " + viewName);
        String ddl = String.format("CREATE VIEW %s.%s.%s AS\nSELECT *\nFROM\n  (\n VALUES \n     ROW (1, 'one')\n   , ROW (2, 't')\n)  t (col1, col2)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName);
        this.assertUpdate(ddl);
        Assert.assertEquals((Object)this.computeActual("SHOW CREATE VIEW " + viewName).getOnlyValue(), (Object)ddl);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testQueryLoggingCount() {
        QueryManager queryManager = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getQueryManager();
        this.executeExclusively(() -> {
            AbstractTestDistributedQueries.assertUntilTimeout(() -> Assert.assertEquals((Collection)queryManager.getQueries().stream().map(BasicQueryInfo::getQueryId).map(arg_0 -> ((QueryManager)queryManager).getFullQueryInfo(arg_0)).filter(info -> !info.isFinalQueryInfo()).collect(Collectors.toList()), (Collection)ImmutableList.of()), new Duration(1.0, TimeUnit.MINUTES));
            DispatchManager dispatchManager = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getDispatchManager();
            long beforeCompletedQueriesCount = this.waitUntilStable(() -> dispatchManager.getStats().getCompletedQueries().getTotalCount(), new Duration(5.0, TimeUnit.SECONDS));
            long beforeSubmittedQueriesCount = dispatchManager.getStats().getSubmittedQueries().getTotalCount();
            String tableName = "test_query_logging_count" + TestTable.randomTableSuffix();
            this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4", 1L);
            this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
            this.assertUpdate("DROP TABLE " + tableName);
            this.assertQueryFails("SELECT * FROM " + tableName, ".*Table .* does not exist");
            AbstractTestDistributedQueries.assertUntilTimeout(() -> Assert.assertEquals((long)(dispatchManager.getStats().getCompletedQueries().getTotalCount() - beforeCompletedQueriesCount), (long)4L), new Duration(1.0, TimeUnit.MINUTES));
            Assert.assertEquals((long)(dispatchManager.getStats().getSubmittedQueries().getTotalCount() - beforeSubmittedQueriesCount), (long)4L);
        });
    }

    private <T> T waitUntilStable(Supplier<T> computation, Duration timeout) {
        T lastValue = computation.get();
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted() && Duration.nanosSince((long)start).compareTo(timeout) < 0) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            T currentValue = computation.get();
            if (currentValue.equals(lastValue)) {
                return currentValue;
            }
            lastValue = currentValue;
        }
        throw new UncheckedTimeoutException();
    }

    private static void assertUntilTimeout(Runnable assertion, Duration timeout) {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                assertion.run();
                return;
            }
            catch (AssertionError e) {
                if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                    throw e;
                }
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    @Test
    public void testShowSchemasFromOther() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)"information_schema", (Object)"tiny", (Object)"sf1")));
    }

    @Test
    public void testSymbolAliasing() {
        String tableName = "test_symbol_aliasing" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4", 1L);
        this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testNonQueryAccessControl() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        this.assertAccessDenied("SET SESSION query_max_memory = '10MB'", "Cannot set system session property query_max_memory", TestingAccessControlManager.privilege((String)"query_max_memory", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_SESSION));
        this.assertAccessDenied("CREATE TABLE foo (pk bigint)", "Cannot create table .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE));
        this.assertAccessDenied("DROP TABLE orders", "Cannot drop table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_TABLE));
        this.assertAccessDenied("ALTER TABLE orders RENAME TO foo", "Cannot rename table .*.orders.* to .*.foo.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_TABLE));
        this.assertAccessDenied("ALTER TABLE orders ADD COLUMN foo bigint", "Cannot add a column to table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ADD_COLUMN));
        this.assertAccessDenied("ALTER TABLE orders DROP COLUMN foo", "Cannot drop a column from table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_COLUMN));
        this.assertAccessDenied("ALTER TABLE orders RENAME COLUMN orderkey TO foo", "Cannot rename a column in table .*.orders.*", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_COLUMN));
        this.assertAccessDenied("CREATE VIEW foo as SELECT * FROM orders", "Cannot create view .*.foo.*", TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW));
        try {
            this.assertAccessDenied("SELECT 1", "Principal .* cannot become user " + this.getSession().getUser() + ".*", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_USER));
        }
        catch (AssertionError e) {
            io.airlift.testing.Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"statusCode=403");
        }
    }

    @Test
    public void testViewColumnAccessControl() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        Session viewOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_view_access_owner")).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        String columnAccessViewName = "test_view_column_access_" + TestTable.randomTableSuffix();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + columnAccessViewName + " AS SELECT * FROM orders", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessDenied("SELECT * FROM " + columnAccessViewName, "View owner 'test_view_access_owner' cannot create view that selects from .*.orders.*", TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed(viewOwnerSession, "SELECT * FROM " + columnAccessViewName, TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM " + columnAccessViewName, TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM " + columnAccessViewName, TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        Session nestedViewOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_nested_view_access_owner")).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        String nestedViewName = "test_nested_view_column_access_" + TestTable.randomTableSuffix();
        this.assertAccessAllowed(nestedViewOwnerSession, "CREATE VIEW " + nestedViewName + " AS SELECT * FROM " + columnAccessViewName, TestingAccessControlManager.privilege((String)columnAccessViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessDenied("SELECT * FROM " + nestedViewName, "View owner 'test_nested_view_access_owner' cannot create view that selects from .*.test_view_column_access.*", TestingAccessControlManager.privilege((String)nestedViewOwnerSession.getUser(), (String)columnAccessViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM " + nestedViewName, TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)columnAccessViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM " + nestedViewName, TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)columnAccessViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        String invokerViewName = "test_invoker_view_column_access_" + TestTable.randomTableSuffix();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + invokerViewName + " SECURITY INVOKER AS SELECT * FROM orders", TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS));
        this.assertAccessAllowed("SELECT * FROM " + invokerViewName, TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SELECT * FROM " + invokerViewName, "Cannot select from columns \\[.*\\] in table .*.orders.*", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN));
        this.assertAccessDenied("SHOW CREATE VIEW " + nestedViewName, "Cannot show create table for .*test_nested_view_column_access.*", TestingAccessControlManager.privilege((String)nestedViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE));
        this.assertAccessAllowed("SHOW CREATE VIEW " + nestedViewName, TestingAccessControlManager.privilege((String)"test_denied_access_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE));
        this.assertAccessAllowed(nestedViewOwnerSession, "DROP VIEW " + nestedViewName, new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + columnAccessViewName, new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + invokerViewName, new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testViewFunctionAccessControl() {
        AbstractTestDistributedQueries.skipTestUnless(this.supportsViews());
        Session viewOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_view_access_owner")).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        String functionAccessViewName = "test_view_function_access_" + TestTable.randomTableSuffix();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + functionAccessViewName + " AS SELECT abs(1) AS c", TestingAccessControlManager.privilege((String)"abs", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.GRANT_EXECUTE_FUNCTION));
        this.assertAccessDenied("SELECT * FROM " + functionAccessViewName, "'test_view_access_owner' cannot grant 'abs' execution to user '\\w*'", TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"abs", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.GRANT_EXECUTE_FUNCTION));
        this.assertAccessAllowed("SELECT * FROM " + functionAccessViewName, TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"abs", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION));
        String invokerFunctionAccessViewName = "test_invoker_view_function_access_" + TestTable.randomTableSuffix();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + invokerFunctionAccessViewName + " SECURITY INVOKER AS SELECT abs(1) AS c", TestingAccessControlManager.privilege((String)"abs", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.GRANT_EXECUTE_FUNCTION));
        this.assertAccessAllowed("SELECT * FROM " + invokerFunctionAccessViewName, TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"abs", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION));
        this.assertAccessDenied("SELECT * FROM " + invokerFunctionAccessViewName, "Cannot execute function abs", TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"abs", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION));
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + functionAccessViewName, new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + invokerFunctionAccessViewName, new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testWrittenStats() {
        String tableName = "test_written_stats_" + TestTable.randomTableSuffix();
        String sql = "CREATE TABLE " + tableName + " AS SELECT * FROM nation";
        DistributedQueryRunner distributedQueryRunner = (DistributedQueryRunner)this.getQueryRunner();
        ResultWithQueryId<MaterializedResult> resultResultWithQueryId = distributedQueryRunner.executeWithQueryId(this.getSession(), sql);
        QueryInfo queryInfo = distributedQueryRunner.getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
        Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
        Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)25L);
        org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        sql = "INSERT INTO " + tableName + " SELECT * FROM nation LIMIT 10";
        resultResultWithQueryId = distributedQueryRunner.executeWithQueryId(this.getSession(), sql);
        queryInfo = distributedQueryRunner.getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
        Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
        Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)10L);
        org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test_schema_create_" + TestTable.randomTableSuffix();
        Assertions.assertThat((Iterable)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{schemaName});
        this.assertUpdate("CREATE SCHEMA " + schemaName);
        Assertions.assertThat((Iterable)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName});
        this.assertQueryFails("CREATE SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' already exists", schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
        this.assertQueryFails("DROP SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' does not exist", schemaName));
    }

    @Test
    public void testInsertForDefaultColumn() {
        try (TestTable testTable = this.createTableWithDefaultColumns();){
            this.assertUpdate(String.format("INSERT INTO %s (col_required, col_required2) VALUES (1, 10)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 3, 4, 5, 6)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (7, null, null, 8, 9)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s (col_required2, col_required) VALUES (12, 13)", testTable.getName()), 1L);
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (1, null, 43, 42, 10), (2, 3, 4, 5, 6), (7, null, null, 8, 9), (13, null, 43, 42, 12)");
        }
    }

    protected abstract TestTable createTableWithDefaultColumns();

    @Test(dataProvider="testColumnNameDataProvider")
    public void testColumnName(String columnName) {
        if (!AbstractTestDistributedQueries.requiresDelimiting(columnName)) {
            this.testColumnName(columnName, false);
        }
        this.testColumnName(columnName, true);
    }

    private void testColumnName(String columnName, boolean delimited) {
        String nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        String tableName = "test_column_names_" + nameInSql.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_") + "_" + TestTable.randomTableSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(id varchar, " + nameInSql + " varchar)");
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')", 3L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')");
        this.assertQuery("SELECT " + nameInSql + " FROM " + tableName, "VALUES (NULL), ('abc'), ('xyz')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE " + nameInSql + " IS NULL", "VALUES ('null value')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE " + nameInSql + " = 'abc'", "VALUES ('sample value')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    protected boolean isColumnNameRejected(Exception exception, String columnName, boolean delimited) {
        return false;
    }

    private static boolean requiresDelimiting(String identifierName) {
        return !identifierName.matches("[a-zA-Z][a-zA-Z0-9_]*");
    }

    @DataProvider
    public Object[][] testColumnNameDataProvider() {
        return new Object[][]{{"lowercase"}, {"UPPERCASE"}, {"MixedCase"}, {"an_underscore"}, {"a-hyphen-minus"}, {"a space"}, {"atrailingspace "}, {" aleadingspace"}, {"a.dot"}, {"a,comma"}, {"a:colon"}, {"a;semicolon"}, {"an@at"}, {"a\"quote"}, {"an'apostrophe"}, {"a`backtick`"}, {"a/slash`"}, {"a\\backslash`"}, {"adigit0"}, {"0startingwithdigit"}};
    }

    @Test(dataProvider="testDataMappingSmokeTestDataProvider")
    public void testDataMappingSmokeTest(DataMappingTestSetup dataMappingTestSetup) {
        String prestoTypeName = dataMappingTestSetup.getPrestoTypeName();
        String sampleValueLiteral = dataMappingTestSetup.getSampleValueLiteral();
        String highValueLiteral = dataMappingTestSetup.getHighValueLiteral();
        String tableName = "test_data_mapping_smoke_" + prestoTypeName.replaceAll("[^a-zA-Z0-9]", "_") + "_" + TestTable.randomTableSuffix();
        Runnable setup = () -> {
            String createTable = "CREATE TABLE " + tableName + " AS SELECT CAST(id AS varchar) id, CAST(value AS " + prestoTypeName + ") value FROM (VALUES   ('null value', NULL),   ('sample value', " + sampleValueLiteral + "),   ('high value', " + highValueLiteral + "))  t(id, value)";
            this.assertUpdate(createTable, 3L);
        };
        if (dataMappingTestSetup.isUnsupportedType()) {
            String typeNameBase = prestoTypeName.replaceFirst("\\(.*", "");
            String expectedMessagePart = String.format("(%1$s.*not (yet )?supported)|((?i)unsupported.*%1$s)|((?i)not supported.*%1$s)", Pattern.quote(typeNameBase));
            Assertions.assertThatThrownBy(setup::run).hasMessageFindingMatch(expectedMessagePart).satisfies(e -> Assertions.assertThat((Throwable)QueryAssertions.getPrestoExceptionCause(e)).hasMessageFindingMatch(expectedMessagePart));
            return;
        }
        setup.run();
        this.assertQuery("SELECT id FROM " + tableName + " WHERE rand() = 42 OR value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE rand() = 42 OR value IS NOT NULL", "VALUES ('sample value'), ('high value')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE rand() = 42 OR value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE rand() = 42 OR value = " + highValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value IS NOT NULL", "VALUES ('sample value'), ('high value')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value != " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value <= " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value > " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value <= " + highValueLiteral, "VALUES ('sample value'), ('high value')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value IS NULL OR value = " + sampleValueLiteral, "VALUES ('null value'), ('sample value')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value IS NULL OR value != " + sampleValueLiteral, "VALUES ('null value'), ('high value')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value IS NULL OR value <= " + sampleValueLiteral, "VALUES ('null value'), ('sample value')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value IS NULL OR value > " + sampleValueLiteral, "VALUES ('null value'), ('high value')");
        this.assertQuery("SELECT id FROM " + tableName + " WHERE value IS NULL OR value <= " + highValueLiteral, "VALUES ('null value'), ('sample value'), ('high value')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * Exception decompiling
     */
    @DataProvider
    public final Object[][] testDataMappingSmokeTestDataProvider() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<DataMappingTestSetup> testDataMappingSmokeTestData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("tinyint", "37", "127")).add((Object)new DataMappingTestSetup("smallint", "32123", "32767")).add((Object)new DataMappingTestSetup("integer", "1274942432", "2147483647")).add((Object)new DataMappingTestSetup("bigint", "312739231274942432", "9223372036854775807")).add((Object)new DataMappingTestSetup("real", "REAL '567.123'", "REAL '999999.999'")).add((Object)new DataMappingTestSetup("double", "DOUBLE '1234567890123.123'", "DOUBLE '9999999999999.999'")).add((Object)new DataMappingTestSetup("decimal(5,3)", "12.345", "99.999")).add((Object)new DataMappingTestSetup("decimal(15,3)", "123456789012.345", "999999999999.99")).add((Object)new DataMappingTestSetup("date", "DATE '2020-02-12'", "DATE '9999-12-31'")).add((Object)new DataMappingTestSetup("time", "TIME '15:03:00'", "TIME '23:59:59.999'")).add((Object)new DataMappingTestSetup("timestamp", "TIMESTAMP '2020-02-12 15:03:00'", "TIMESTAMP '2199-12-31 23:59:59.999'")).add((Object)new DataMappingTestSetup("timestamp with time zone", "TIMESTAMP '2020-02-12 15:03:00 +01:00'", "TIMESTAMP '9999-12-31 23:59:59.999 +12:00'")).add((Object)new DataMappingTestSetup("char(3)", "'ab'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar(3)", "'de'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar", "'\u0142\u0105ka for the win'", "'\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b'")).add((Object)new DataMappingTestSetup("varbinary", "X'12ab3f'", "X'ffffffffffffffffffff'")).build();
    }

    protected Optional<DataMappingTestSetup> filterDataMappingSmokeTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    private static /* synthetic */ Object[][] lambda$testDataMappingSmokeTestDataProvider$8(int x$0) {
        return new Object[x$0][];
    }

    protected static final class DataMappingTestSetup {
        private final String prestoTypeName;
        private final String sampleValueLiteral;
        private final String highValueLiteral;
        private final boolean unsupportedType;

        public DataMappingTestSetup(String prestoTypeName, String sampleValueLiteral, String highValueLiteral) {
            this(prestoTypeName, sampleValueLiteral, highValueLiteral, false);
        }

        private DataMappingTestSetup(String prestoTypeName, String sampleValueLiteral, String highValueLiteral, boolean unsupportedType) {
            this.prestoTypeName = Objects.requireNonNull(prestoTypeName, "prestoTypeName is null");
            this.sampleValueLiteral = Objects.requireNonNull(sampleValueLiteral, "sampleValueLiteral is null");
            this.highValueLiteral = Objects.requireNonNull(highValueLiteral, "highValueLiteral is null");
            this.unsupportedType = unsupportedType;
        }

        public String getPrestoTypeName() {
            return this.prestoTypeName;
        }

        public String getSampleValueLiteral() {
            return this.sampleValueLiteral;
        }

        public String getHighValueLiteral() {
            return this.highValueLiteral;
        }

        public boolean isUnsupportedType() {
            return this.unsupportedType;
        }

        public DataMappingTestSetup asUnsupported() {
            return new DataMappingTestSetup(this.prestoTypeName, this.sampleValueLiteral, this.highValueLiteral, true);
        }

        public String toString() {
            return this.prestoTypeName + (this.unsupportedType ? "!" : "");
        }
    }
}

