/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.sql;

import io.prestosql.Session;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.sql.SqlExecutor;
import java.util.Objects;

public class PrestoSqlExecutor
implements SqlExecutor {
    private final QueryRunner queryRunner;
    private final Session session;

    public PrestoSqlExecutor(QueryRunner queryRunner) {
        this(queryRunner, queryRunner.getDefaultSession());
    }

    public PrestoSqlExecutor(QueryRunner queryRunner, Session session) {
        this.queryRunner = Objects.requireNonNull(queryRunner, "queryRunner is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public void execute(String sql) {
        try {
            this.queryRunner.execute(this.session, sql);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error executing sql:\n" + sql, e);
        }
    }
}

