/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.sql;

import com.google.common.collect.ImmutableList;
import io.prestosql.testing.sql.SqlExecutor;
import java.security.SecureRandom;
import java.util.List;

public class TestTable
implements AutoCloseable {
    private static final SecureRandom random = new SecureRandom();
    private static final int RANDOM_SUFFIX_LENGTH = 12;
    private final SqlExecutor sqlExecutor;
    private final String name;

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, String tableDefinition) {
        this(sqlExecutor, namePrefix, tableDefinition, (List<String>)ImmutableList.of());
    }

    public TestTable(SqlExecutor sqlExecutor, String namePrefix, String tableDefinition, List<String> rowsToInsert) {
        this.sqlExecutor = sqlExecutor;
        this.name = namePrefix + "_" + TestTable.randomTableSuffix();
        sqlExecutor.execute(String.format("CREATE TABLE %s %s", this.name, tableDefinition));
        try {
            for (String row : rowsToInsert) {
                sqlExecutor.execute(String.format("INSERT INTO %s VALUES (%s)", this.name, row));
            }
        }
        catch (Exception e) {
            TestTable ignored = this;
            Throwable throwable = null;
            try {
                try {
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ignored.close();
                    }
                }
                throw throwable3;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.sqlExecutor.execute("DROP TABLE " + this.name);
    }

    public static String randomTableSuffix() {
        String randomSuffix = Long.toString(Math.abs(random.nextLong()), 36);
        return randomSuffix.substring(0, Math.min(12, randomSuffix.length()));
    }
}

