/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.tpch;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.prestosql.plugin.tpch.TpchMetadata;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorIndexHandle;
import io.prestosql.spi.connector.ConnectorResolvedIndex;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.testing.tpch.TpchIndexHandle;
import io.prestosql.testing.tpch.TpchIndexProvider;
import io.prestosql.testing.tpch.TpchIndexedData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TpchIndexMetadata
extends TpchMetadata {
    private final TpchIndexedData indexedData;

    public TpchIndexMetadata(TpchIndexedData indexedData) {
        this.indexedData = Objects.requireNonNull(indexedData, "indexedData is null");
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        Map<ColumnHandle, NullableValue> fixedValues = ((Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of())).entrySet().stream().filter(entry -> !indexableColumns.contains(entry.getKey())).filter(entry -> !((NullableValue)entry.getValue()).isNull()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableSet lookupColumnNames = ImmutableSet.builder().addAll(TpchIndexProvider.handleToNames((List<ColumnHandle>)ImmutableList.copyOf(indexableColumns))).addAll(TpchIndexProvider.handleToNames((List<ColumnHandle>)ImmutableList.copyOf(fixedValues.keySet()))).build();
        if (!this.indexedData.getIndexedTable(tpchTableHandle.getTableName(), tpchTableHandle.getScaleFactor(), (Set<String>)lookupColumnNames).isPresent()) {
            return Optional.empty();
        }
        TupleDomain filteredTupleDomain = tupleDomain;
        if (!tupleDomain.isNone()) {
            filteredTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)tupleDomain.getDomains().get()), (Predicate)Predicates.not((Predicate)Predicates.in(fixedValues.keySet()))));
        }
        TpchIndexHandle indexHandle = new TpchIndexHandle(tpchTableHandle.getTableName(), tpchTableHandle.getScaleFactor(), (Set<String>)lookupColumnNames, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues(fixedValues));
        return Optional.of(new ConnectorResolvedIndex((ConnectorIndexHandle)indexHandle, filteredTupleDomain));
    }
}

